package com.yeejoin.amos.api.openapi.feign;


import com.yeejoin.amos.api.openapi.config.FeignConfiguration;
import com.yeejoin.amos.api.openapi.face.dto.EquipmentCategoryDto;
import com.yeejoin.amos.api.openapi.face.dto.EquipmentInfoDto;
import com.yeejoin.amos.api.openapi.face.model.InspectionDetectionInfoModel;
import com.yeejoin.amos.api.openapi.face.model.UnitLicenceModel;
import com.yeejoin.amos.api.openapi.face.orm.entity.ConstructionInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MaintenanceInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(name = "TZS-YMT", path = "/ymt", configuration =
        {FeignConfiguration.class})
public interface TzsServiceFeignClient {

    /**
     * 根据企业名称查询许可信息
     *
     * @param unitCode 企业唯一编码
     * @return
     */
    @RequestMapping(value = "/baseUnitLicence/licences", method = RequestMethod.GET)
    ResponseModel<List<UnitLicenceModel>> getLicenceByUnitCode(@RequestParam String unitCode);


    /**
     * 创建监管码及96333
     *
     * @param map 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/createSupervisorCode", method = RequestMethod.POST)
    ResponseModel<Map<String, Object>> createCode(@RequestBody Map<String, Object> map);


    /**
     * 修改数据状态
     *
     * @param map 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/updateOtherInfo", method = RequestMethod.POST)
    ResponseModel<Object> updateStatus(@RequestBody Map<String, Object> map);

    /**
     * 检验检测信息（查询）
     *
     * @param superviseCode 监管码
     * @return
     */
    @RequestMapping(value = "/api/inspectiondetectioninfo/selectInspect", method = RequestMethod.GET)
    ResponseModel<InspectionDetectionInfoModel> selectInspect(@RequestParam String superviseCode);

    /**
     * 保存监管设备数据
     *
     * @param equipmentInfoDto 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/saveSupervisoryData", method = RequestMethod.POST)
    ResponseModel<Boolean> saveEquipmentInfo(@RequestBody EquipmentInfoDto equipmentInfoDto);

    /**
     * 保存监管设备施工数据
     *
     * @param constructionInfo 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/saveConstructionInfoData", method = RequestMethod.POST)
    ResponseModel<Boolean> saveConstructionInfo(@RequestBody ConstructionInfo constructionInfo);

    /**
     * 保存监管维保数据
     *
     * @param maintenanceInfo 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/saveMaintenanceRecordInfoData", method = RequestMethod.POST)
    ResponseModel<Boolean> saveMaintenanceRecordInfo(@RequestBody MaintenanceInfo maintenanceInfo);

    /**
     * 删除监管设备数据
     *
     * @param record
     * @return
     */
    @RequestMapping(value = "/equipment-category/deleteByRecord", method = RequestMethod.POST)
    ResponseModel<Boolean> deleteEquipmentInfo(@RequestParam String record);

    /**
     * 设备定义列表数据
     * @return <List<EquipmentCategoryDto>>
     */
    @RequestMapping(value = "/equipment-category/list", method = RequestMethod.GET)
    ResponseModel<List<EquipmentCategoryDto>> getEquipmentCategoryList();

}
