package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface JgUseRegistrationMapper extends BaseMapper<JgUseRegistration> {

    Page<Map<String, Object>> getListPage(@Param("page") Page<Map<String, Object>> page,
                                          @Param("sort") SortVo sortMap,
                                          @Param("dto") JgUseRegistrationDto dto,
                                          @Param("roleIds") List<String> roleIds);

    Map<String, Object> getDetail(@Param("id") String id);

    Map<String, Object> getSupervisionInfoDetail(@Param("id") String id);

    Map<String, Object> getInspectDetail(@Param("id") String id, @Param("permissionInspectTypes") List<String> permissionInspectTypes);

    Map<String, Object> getUseDetail(@Param("id") String id);

    Map<String, Object> getDesDetail(@Param("id") String id);

    Page<Map<String, Object>> getEquipListPage(@Param("page") Page<Map<String, Object>> page, @Param("factoryNum") String factoryNum, @Param("equList") String equList, @Param("equCategory") String equCategory);

    void updatePromoter(@Param("id") Long id);

    List<Map<String, Object>> getDetailById(@Param("id") Long id);

    String getEquType(@Param("record") String record);

    Map<String, Object> getMaintenanceDetail(@Param("id") String id);

    Map<String, Object> getiInstallDetail(@Param("id") String id);

    Map<String, Object> getUseRegistrationDetail(@Param("id") String id);

    Page<JSONObject> queryForUnitVesselEquipmentPage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject, @Param("records") Set<String> records);

    Page<JSONObject> queryForEquipUsedByVehiclePage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject);

    @MapKey("records")
    List<Map<String, Object>> queryForUnitVesselEquipment(@Param("records") List<String> records);

    Page<JSONObject> queryForUnitPipelineEquipmentPage(@Param("page") Page<JSONObject> page, @Param("jsonObject") JSONObject jsonObject, @Param("records") Set<String> records);

    @MapKey("records")
    List<Map<String, Object>> queryForUnitPipelineEquipment(@Param("records") List<String> records);

    @MapKey("id")
    List<Map<String, Object>> selectEquipList(@Param("id") Long id);

    List<CompanyEquipCountDto> queryForFlowingEquipList();
}
