package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.GroupAndPersonInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsEquipListDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface TzsUserInfoMapper extends BaseMapper<TzsUserInfo> {
    Page<TzsUserInfoDto> selectPageMessage(@Param("page") Page<TzsUserInfoDto> page, @Param("dto") TzsUserInfoDto dto);

    List<Map<String, Object>> getUserType(@Param("unitType")String unitType, @Param("install") String install);

    Map<String, Integer> getArrangementStatistic(String companyCode);

    Page<TzsEquipListDto> getAllEquipList(@Param("page") Page<TzsEquipListDto> page,
                                          @Param("type") String type,
                                          @Param("companyCode") String companyCode,
                                          @Param("userSeq") String userSeq,
                                          @Param("dto") TzsEquipListDto dto);

    List<TzsUserInfo> getUnitPersonInfo();

    List<String> selectUserIds();

    List<GroupAndPersonInfoDto> getUnitInfoByUserId(Long groupId);

    String selectPostNameByUserId(String userId);

    List<Map<String, Object>> getUserTypeList(@Param(value = "typeList") List<String> typeList);

    String selectCompanyTypeById(Long companySeq);
}
