package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationUnitService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.biz.context.EquipUsedCheckStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.feign.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICompensateFlowDataOfRedis;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.*;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.lang3.ObjectUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl.getAuditPassedDate;

/**
 * 单位变更登记服务实现类
 *
 * @author system_generator
 * @date 2023-12-22
 */
@Service
public class JgChangeRegistrationUnitServiceImpl extends BaseService<JgChangeRegistrationUnitDto, JgChangeRegistrationUnit, JgChangeRegistrationUnitMapper> implements IJgChangeRegistrationUnitService, ICompensateFlowDataOfRedis<JgChangeRegistrationUnit> {
    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String PROCESS_DEFINITION_KEY = "unitChange";
    private static final String TABLE_PAGE_ID = "1734141426742095873";
    private final List<String> NOT_FLOWING_STATE = Arrays.asList("使用单位待提交", "一级受理已驳回", "使用单位已撤回", "已作废", "已完成");


    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    JgChangeRegistrationUnitEqMapper JgChangeRegistrationUnitEqMapper;

    @Autowired
    JgChangeRegistrationUnitEqServiceImpl registrationUnitEqService;

    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;
    @Autowired
    private JgChangeRegistrationUnitMapper JgChangeRegistrationUnitMapper;

    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    UseInfoMapper useInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;
    @Autowired
    CommonServiceImpl commonServiceImpl;

    @Autowired
    WorkFlowFeignService workFlowFeginService;

    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;

    @Autowired
    private JgScrapCancelMapper jgScrapCancelMapper;

    @Autowired
    private JgScrapCancelEqMapper jgScrapCancelEqMapper;

    @Autowired
    private SuperviseInfoMapper superviseInfoMapper;

    @Autowired
    private IdxBizJgUseInfoMapper idxBizJgUseInfoMapper;

    @Autowired
    private JgUseRegistrationManageMapper jgUseRegistrationManageMapper;

    @Autowired
    private JgCertificateChangeRecordEqServiceImpl jgCertificateChangeRecordEqServiceImpl;

    //改造登记关系表mapper
    @Autowired
    private JgChangeRegistrationReformEqMapper jgChangeRegistrationReformEqMapper;
    //移装登记关系表
    @Autowired
    private JgChangeRegistrationTransferEqMapper jgChangeRegistrationTransferEqMapper;
    //使用登记关系表mapper
    @Autowired
    private JgUseRegistrationEqMapper jgUseRegistrationEqMapper;
    //单位变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationUnitEqMapper jgChangeRegistrationUnitEqMapper;
    //更名变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationNameEqMapper jgChangeRegistrationNameEqMapper;

    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;

    @Autowired
    ICommonService commonService;

    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    JgUseRegistrationManageServiceImpl registrationManageService;
    @Autowired
    JgRegistrationHistoryServiceImpl registrationHistoryService;

    @Autowired
    private SnowflakeIdUtil sequence;

    @Autowired
    JgCertificateChangeRecordServiceImpl certificateChangeRecordService;

    @Autowired
    JgCertificateChangeRecordEqServiceImpl certificateChangeRecordEqService;

    @Autowired
    JgUseRegistrationManageServiceImpl useRegistrationManageService;

    @Autowired
    private TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

    /**
     * 根据sequenceNbr查询：1、查询单位变更信息，2、查询使用登记证列表
     *
     * @param sequenceNbr 主键
     * @param selectedOrgInfo
     * @return 单位变更
     */
    @Override
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr, ReginParams selectedOrgInfo) {
        // 单位变更信息
        JgChangeRegistrationUnit notice = JgChangeRegistrationUnitMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        this.doCompensate(notice);
        Map<String, Object> changeInfo = BeanUtil.beanToMap(notice, false, true);
        //回填新单位地址，台套办理的使用登记证打印时 需要，用来校验必输
        if (!ObjectUtils.isEmpty(notice.getNewUseUnitCreditCode())) {
            TzBaseEnterpriseInfo useCodeResult = tzBaseEnterpriseInfoMapper.selectOne(new LambdaQueryWrapper<TzBaseEnterpriseInfo>().eq(TzBaseEnterpriseInfo::getUseUnitCode, notice.getNewUseUnitCreditCode()));
            if (useCodeResult != null) {
                changeInfo.put("address",useCodeResult.getAddress());
            }
        }
        //组装下拉数据
        if (!ValidationUtil.isEmpty(notice.getReceiveOrgCode()) && !ValidationUtil.isEmpty(notice.getReceiveOrgName())) {
            changeInfo.put("receiveOrgCode", notice.getReceiveOrgCode() + "_" + notice.getReceiveOrgName());
        }
        if (!ValidationUtil.isEmpty(notice.getUseUnitCreditCode()) && !ValidationUtil.isEmpty(notice.getUseUnitName())) {
            changeInfo.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        }
        if (!ValidationUtil.isEmpty(notice.getNewUseUnitCreditCode()) && !ValidationUtil.isEmpty(notice.getNewUseUnitName())) {
            changeInfo.put("newUseUnitCreditCode", notice.getNewUseUnitCreditCode() + "_" + notice.getNewUseUnitName());
        }
        //附件格式处理
        changeInfo.put("changeCertificateList", JSON.parse(notice.getChangeCertificate()));
        changeInfo.put("otherAccessoriesList", JSON.parse(notice.getOtherAccessories()));
        //查询使用登记证列表
        JgRegistrationHistory historyServiceOne = registrationHistoryService.getOne(
                new LambdaQueryWrapper<JgRegistrationHistory>()
                        .eq(JgRegistrationHistory::getCurrentDocumentId, notice.getApplyNo())
                        .eq(JgRegistrationHistory::getIsDelete, false));
        changeInfo.put("registrationList", JSON.parse(historyServiceOne.getChangeData()));
        changeInfo.put("havingPermission", notice.getNextExecuteUserIds() != null && notice.getNextExecuteUserIds().contains(RequestContext.getExeUserId()));
        String companyType = selectedOrgInfo.getCompany().getCompanyType();
        if ("个人主体".equals(companyType)) {
            changeInfo.put("companyType", "person");
        } else {
            changeInfo.put("companyType", "company");
        }
        return new HashMap<String, Map<String, Object>>() {{
//            this.put("changeRegisInfo", fillEquipInfoWithRuntimeOrHistoryData(notice, changeInfo));
            this.put("changeRegisInfo", changeInfo);
        }};
    }

    private Map<String, Object> fillEquipInfoWithRuntimeOrHistoryData(JgChangeRegistrationUnit notice, Map<String, Object> changeInfo) {
        // 已完成时显示历史数据
        if (notice.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName())) {
            JSONObject his = commonService.queryHistoryData(notice.getSequenceNbr());
            // 兼容老数据
            if (his == null) {
                return getEquipInfo(notice.getSequenceNbr(), changeInfo);
            }
            CommonServiceImpl.formatTime2StrDateForEquip(his);
            his.putAll(changeInfo);
            return his;
        }
        // 非完成状态返回实时使用登记证数据
        return getEquipInfo(notice.getSequenceNbr(), changeInfo);
    }


    private Map<String, Object> getEquipInfo(Long sequenceNbr, Map<String, Object> changeInfo) {
        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport", "otherAccessoriesList",
                "proxyStatementAttachment", "installContractAttachment", "changeCertificateList"};

        // 设备信息
        List<Map<String, Object>> equipmentInfos = JgChangeRegistrationUnitMapper.queryEquipInformation(sequenceNbr);
        String equipId = JgChangeRegistrationUnitMapper.queryEquipIdBySeq(sequenceNbr);
        Map<String, Object> detailFieldCamelCaseByRecord = idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(equipId);
        detailFieldCamelCaseByRecord.remove("useUnitCreditCode");


        for (String s : fields) {
            if (changeInfo.containsKey(s) && !ObjectUtils.isEmpty(changeInfo.get(s))) {
                changeInfo.put(s, JSON.parseArray(changeInfo.get(s).toString()));
            }
            if (equipmentInfos.get(0).containsKey(s) && !ObjectUtils.isEmpty(equipmentInfos.get(0).get(s))) {
                equipmentInfos.get(0).put(s, JSON.parseArray(equipmentInfos.get(0).get(s).toString()));
            }
        }

        Map<String, Object> newMap = new HashMap<>();
        newMap.putAll(detailFieldCamelCaseByRecord);
        newMap.putAll(changeInfo);
        newMap.putAll(equipmentInfos.get(0));
        return newMap;
    }

    /**
     * 更新单位变更
     *
     * @param noticeDto 单位变更
     */
    @GlobalTransactional(rollbackFor = Exception.class)
    public JgChangeRegistrationUnitDto updateInstallationNotice(String submitType, JgChangeRegistrationUnitDto noticeDto, String op, ReginParams reginParams) {
        if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // 字段转换
        this.convertField(noticeDto);
        // 获取单位变更使用登记证列表
        List<Map<String, Object>> registrationList = noticeDto.getRegistrationList();
        if (CollectionUtils.isEmpty(registrationList)) {
            throw new BadRequest("使用登记证不能为空");
        }
        //根据使用登记证查询设备
        List<Long> registrationIdList = registrationList.stream().filter(v -> v.containsKey("sequenceNbr") &&
                        ObjectUtils.isNotEmpty(v.get("sequenceNbr")) && canConvertToLong(v.get("sequenceNbr").toString()))
                .map(v -> Long.parseLong(v.get("sequenceNbr").toString())).collect(Collectors.toList());
        // 获取单位变更设备列表
        if (CollectionUtils.isEmpty(registrationIdList)) {
            throw new BadRequest("使用登记证不能为空");
        }
        List<JSONObject> deviceList = registrationManageService.queryEquByCertificateSeqList(registrationIdList);
        // 获取单位变更设备列表
        if (CollectionUtils.isEmpty(deviceList)) {
            throw new BadRequest("使用登记证下无设备");
        }
        ArrayList<String> roleListAll = new ArrayList<>();
        ArrayList<String> roleListNext = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            // 发起流程
            if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                List<ProcessTaskDTO> processTasks = new ArrayList<>();
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(String.valueOf(new Date().getTime()));
                dto.setCompleteFirstTask(true);
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                dto.setNextExecuteUserCompanyCode(noticeDto.getReceiveCompanyCode());
                processTasks = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                String instanceId = processTasks.get(0).getProcessInstance().getId();
                String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                String taskname = processTasks.get(0).getNextTask().get(0).getName();
                this.buildRoleList(processTasks, roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(processTasks);
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();

                JgChangeRegistrationUnit notice = new JgChangeRegistrationUnit();
                BeanUtils.copyProperties(noticeDto, notice);
                notice.setChangeCertificate(noticeDto.getChangeCertificate());
                notice.setRemark(noticeDto.getRemark());
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + roleListAll);
                } else {
                    notice.setInstanceStatus(String.join(",", roleListAll));
                }
                notice.setInstanceId(instanceId);
                notice.setNextTaskId(nextTaskId);
                notice.setSupervisoryCode(noticeDto.getSupervisoryCode());
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecutorIds(String.join(",", roleListNext));
                notice.setStatus(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
                notice.setNextExecuteUserIds(nextUserIds);
                setNewUnitInfo(reginParams, notice);
                JgChangeRegistrationUnitMapper.updateById(notice);
                commonServiceImpl.deleteTasksByRelationId(notice.getSequenceNbr() + "");
                createTaskModel(notice, taskname, "1", nextUserIds);
                commonServiceImpl.saveExecuteFlowData2Redis(notice.getInstanceId(), buildInstanceRuntimeData(notice));
            } else {
                ArrayList<String> roleList = new ArrayList<>();
                String taskId = noticeDto.getNextTaskId();
                //组装信息
                TaskResultDTO task = new TaskResultDTO();
                task.setResultCode("approvalStatus");
                task.setTaskId(taskId);
                task.setComment("");
                HashMap<String, Object> map = new HashMap<>();
                map.put("approvalStatus", op);
                if (!ObjectUtils.isEmpty(noticeDto.getInstanceStatus()) &&
                        (noticeDto.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) ||
                                noticeDto.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack()))) {
                    map.put("approvalStatus", "提交");
                }
                task.setVariable(map);
                //执行流程
                task.setNextExecuteUserCompanyCode(noticeDto.getReceiveCompanyCode());
                ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(taskId, task, op);
                JgChangeRegistrationUnit bean = new JgChangeRegistrationUnit();
                BeanUtils.copyProperties(noticeDto, bean);
                String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
                String taskName1 = "";
                String nextTaskId = "";
                this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                if (processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() > 0) {
                    taskCode = processTaskDTO.getNextTask().get(0).getKey();
                    taskName1 = processTaskDTO.getNextTask().get(0).getName();
                    nextTaskId = processTaskDTO.getNextTask().get(0).getId();
                }
                bean.setNextExecutorIds(String.join(",", roleList));
                if (!ObjectUtils.isEmpty(bean.getInstanceStatus())) {
                    bean.setInstanceStatus(bean.getInstanceStatus() + "," + String.join(",", roleList));
                } else {
                    bean.setInstanceStatus(String.join(",", roleList));
                }
                bean.setNextTaskId(nextTaskId);
                bean.setPromoter(RequestContext.getExeUserId());
                bean.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                executeOneStep(bean, taskName1, nextUserIds, op);
                bean.setNextExecuteUserIds(nextUserIds);
                setNewUnitInfo(reginParams, bean);
                JgChangeRegistrationUnitMapper.updateById(bean);
                commonServiceImpl.saveExecuteFlowData2Redis(bean.getInstanceId(), buildInstanceRuntimeData(bean));
            }
        } else {
            JgChangeRegistrationUnit bean = new JgChangeRegistrationUnit();
            BeanUtils.copyProperties(noticeDto, bean);
            setNewUnitInfo(reginParams, bean);
            JgChangeRegistrationUnitMapper.updateById(bean);
        }
        List<JgChangeRegistrationUnitEq> jgRelationEquipList = new ArrayList<>();
        deviceList.forEach(device -> {
            JgChangeRegistrationUnitEq unitEq = new JgChangeRegistrationUnitEq();
            if (device.containsKey("USE_ORG_CODE")) {
                unitEq.setRegistrationCertificate(device.getString("USE_ORG_CODE"));//使用登记证主键
            }
            if (device.containsKey("SEQUENCE_NBR")) {
                unitEq.setEquId(device.getString("SEQUENCE_NBR"));//设备主键
            }
            unitEq.setUnitChangeRegistrationId(noticeDto.getSequenceNbr().toString());//单位变更业务主键
            unitEq.setDeviceInfo(JSONObject.toJSONString(device));//设备信息json
            jgRelationEquipList.add(unitEq);
        });
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        //登记类别
        jgRegistrationHistory.setRegistrationClass("单位变更登记");
        jgRegistrationHistory.setCurrentDocumentId(noticeDto.getApplyNo());
        //使用登记证历史数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(registrationList));
        //先删除之前设备关系数据，在插入最新设备关系数据
        registrationUnitEqService.getBaseMapper().delete(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>()
                .eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, noticeDto.getSequenceNbr()));
        registrationUnitEqService.saveBatch(jgRelationEquipList);
        //先删除之前未提交的历史使用登记证信息，在插入最新的使用登记证信息
        registrationHistoryService.getBaseMapper().delete(new LambdaQueryWrapper<JgRegistrationHistory>()
                .eq(JgRegistrationHistory::getCurrentDocumentId, noticeDto.getApplyNo()));
        registrationHistoryService.save(jgRegistrationHistory);

        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            //如果是提交，用于校验设备是否已经在流程中，如果不在标记设备已经在流程中
            CompanyBo company = reginParams.getCompany();
            deviceList.forEach(jsonObject -> EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY)
                    .equipRepeatUsedCheck(String.valueOf(jsonObject.get("SEQUENCE_NBR")),
                            CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                                    company.getCompanyCode().split("_")[1] :
                                    company.getCompanyCode()));
        }
        return noticeDto;
    }

    private void setNewUnitInfo(ReginParams reginParams, JgChangeRegistrationUnit notice) {
        notice.setNewUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(reginParams.getCompany().getCompanyType()) ?
                reginParams.getCompany().getCompanyName().split("_")[1] : reginParams.getCompany().getCompanyName());
        notice.setNewUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(reginParams.getCompany().getCompanyType()) ?
                reginParams.getCompany().getCompanyCode().split("_")[1] :
                reginParams.getCompany().getCompanyCode());
    }


    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 单位变更列表
     */
    @Override
    public Page<JgChangeRegistrationUnitDto> queryForJgChangeRegistrationUnitPage(Page<JgChangeRegistrationUnit> page,
                                                                                  String sort,
                                                                                  JgChangeRegistrationUnitDto model,
                                                                                  String type,
                                                                                  ReginParams reginParams) {
        String orgCode = reginParams.getCompany().getCompanyCode();
        if (CompanyTypeEnum.INDIVIDUAL.getName().equals(reginParams.getCompany().getCompanyType())) {
            orgCode = reginParams.getCompany().getCompanyCode().split("_")[1];
        }
        String companyType = reginParams.getCompany().getCompanyType();
        String currentUserId = reginParams.getUserModel().getUserId();
        SortVo sortMap = commonServiceImpl.sortFieldConversion(sort);
        Page<JgChangeRegistrationUnit> noticePage = JgChangeRegistrationUnitMapper.queryForPage(page, sortMap, model, type, orgCode, model.getRoleIds(), currentUserId);

        Page<JgChangeRegistrationUnitDto> noticeDtoPage = new Page<>();
        BeanUtils.copyProperties(noticePage, noticeDtoPage, "records");
        List<JgChangeRegistrationUnitDto> records = noticePage.getRecords().stream().map(notice -> {
            JgChangeRegistrationUnitDto noticeDto = new JgChangeRegistrationUnitDto();
            BeanUtils.copyProperties(notice, noticeDto);
            noticeDto.setCompanyType(companyType);
            return noticeDto;
        }).collect(Collectors.toList());
        noticeDtoPage.setRecords(records);

        return noticeDtoPage;
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        for (Long sequenceNbr : sequenceNbrs) {
            JgChangeRegistrationUnit changeRegistrationUnit = this.baseMapper.selectById(sequenceNbr);
            // 删除代办 + 中止流程
            commonServiceImpl.deleteTaskModel(String.valueOf(sequenceNbr), changeRegistrationUnit.getInstanceId());
            // 删除单子
            this.baseMapper.deleteById(sequenceNbr);
            // 删除单子对应eq
            jgChangeRegistrationUnitEqMapper.delete(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>()
                    .eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, sequenceNbr));
            // 删除单子对应历史表数据
            jgRegistrationHistoryMapper.delete(new LambdaQueryWrapper<JgRegistrationHistory>()
                    .eq(JgRegistrationHistory::getCurrentDocumentId, changeRegistrationUnit.getApplyNo()));
        }
        return Boolean.TRUE;
    }

    public void saveRecord(JgChangeRegistrationUnit registrationUnit) {
        Long sequenceNbr = registrationUnit.getSequenceNbr();
        List<JgChangeRegistrationUnitEq> eqList = registrationUnitEqService.lambdaQuery().eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, sequenceNbr).list();
        List<JgRegistrationHistory> historyList = registrationHistoryService.lambdaQuery().eq(JgRegistrationHistory::getCurrentDocumentId, registrationUnit.getApplyNo()).list();
        if (historyList.size() != 1) {
            return;
        }
        List<JgCertificateChangeRecord> changeRecordList = new ArrayList<>();
        List<JgCertificateChangeRecordEq> changeRecordEqList = new ArrayList<>();
        JSONArray historyJson = JSON.parseArray(historyList.get(0).getChangeData());
        for (Object object : historyJson) {
            JgCertificateChangeRecord changeRecord = new JgCertificateChangeRecord();
            long nextId = sequence.nextId();
            JSONObject jsonObject = JSON.parseObject(object.toString());
            String registrationCode = jsonObject.getString("useRegistrationCode");
            String certificateNo = jsonObject.getString("certificateNo");
            String equCategoryCode = jsonObject.getString("equCategoryCode");
            changeRecord.setApplyNo(registrationUnit.getApplyNo());//申请编号
            changeRecord.setReceiveOrgName(registrationUnit.getReceiveOrgName());//接收机构/登记机关
            changeRecord.setAuditPassDate(registrationUnit.getApplyDate());//办理日期
            changeRecord.setRegType("单位变更登记");//登记类别
            changeRecord.setRegDate(registrationUnit.getCreateDate());//申请日期
            changeRecord.setChangeContent(this.buildRecordContent(registrationUnit));//变更内容
            changeRecord.setUseRegistrationCode(registrationCode);//使用登记编号
            changeRecord.setReceiveCompanyCode(registrationUnit.getReceiveCompanyCode());//接收机构公司代码
            changeRecord.setCertificateNo(certificateNo);//登记证书唯一码
            changeRecord.setUseUnitCreditCode(registrationUnit.getNewUseUnitCreditCode());//使用单位统一信用代码
            changeRecord.setUseUnitName(registrationUnit.getNewUseUnitName());//使用单位名称
            changeRecord.setEquCategory(equCategoryCode);//设备类别编码
            changeRecord.setCreateDate(new Date());
            changeRecord.setSequenceNbr(nextId);
            changeRecordList.add(changeRecord);
            for (JgChangeRegistrationUnitEq unitEq : eqList) {
                if (!StringUtils.isEmpty(unitEq.getRegistrationCertificate()) && !StringUtils.isEmpty(registrationCode) &&
                        unitEq.getRegistrationCertificate().equals(registrationCode)) {
                    JSONObject deviceJson = JSON.parseObject(unitEq.getDeviceInfo());
                    JgCertificateChangeRecordEq changeRecordEq = new JgCertificateChangeRecordEq();
                    changeRecordEq.setChangeRecordId(String.valueOf(nextId));//登记证记录主键
                    changeRecordEq.setEquId(deviceJson.getString("SEQUENCE_NBR"));//设备主键
                    changeRecordEqList.add(changeRecordEq);
                }
            }
        }
        if (!changeRecordList.isEmpty()) {
            certificateChangeRecordService.saveBatch(changeRecordList);
        }
        if (!changeRecordEqList.isEmpty()) {
            certificateChangeRecordEqService.saveBatch(changeRecordEqList);
        }
    }

    private void checkForRepeatUsedEquip(JSONObject map, CompanyBo company) {
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            // 流程中或已完成
            EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY).equipRepeatUsedCheck(map.get("equipId").toString(), company.getCompanyCode());
        }
    }

    @Override
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<JgChangeRegistrationUnitDto> saveNotice(String submitType, JSONObject map, ReginParams reginParams) {
        JgChangeRegistrationUnitDto model = BeanUtil.toBeanIgnoreError(map.get("changeRegisInfo"), JgChangeRegistrationUnitDto.class);
        String[] taskName = new String[]{"流程结束"};
        // 字段转换
        convertField(model);
        // 获取单位变更使用登记证列表
        List<Map<String, Object>> registrationList = model.getRegistrationList();
        if (CollectionUtils.isEmpty(registrationList)) {
            throw new BadRequest("使用登记证不能为空");
        }
        //根据使用登记证查询设备
        List<Long> registrationIdList = new ArrayList<>();//使用登记证id
        List<String> registrationNoList = new ArrayList<>();//使用登记证编号
        for (Map<String, Object> objectMap : registrationList) {
            if (objectMap.containsKey("sequenceNbr") && ObjectUtils.isNotEmpty(objectMap.get("sequenceNbr"))
                    && canConvertToLong(objectMap.get("sequenceNbr").toString())) {
                registrationIdList.add(Long.parseLong(objectMap.get("sequenceNbr").toString()));
            }
            if (objectMap.containsKey("useRegistrationCode") && ObjectUtils.isNotEmpty(objectMap.get("useRegistrationCode"))) {
                registrationNoList.add(objectMap.get("useRegistrationCode").toString());
            }
        }
        if (CollectionUtils.isEmpty(registrationIdList)) {
            throw new BadRequest("使用登记证不能为空");
        }

        List<JSONObject> deviceList = registrationManageService.queryEquByCertificateSeqList(registrationIdList);
        // 获取单位变更设备列表
        if (CollectionUtils.isEmpty(deviceList)) {
            throw new BadRequest("使用登记证下无设备");
        }

        // 获取单位变更单号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.DWBG.getCode(), 1);
        List<String> applyNoList = listResponseModel.getResult();
        if (CollectionUtils.isEmpty(applyNoList)) {
            log.error("生成申请变更单位编码失败");
            return new ArrayList<>();
        }
        ArrayList<String> roleListFirst = new ArrayList<>();
        List<String> instanceIdList = new ArrayList<>();
        List<String> nextExecutorUserIds = new ArrayList<>();
        List<String> taskIds = new ArrayList<>();
        List<WorkflowResultDto> workflowResultDtos = new ArrayList<>();
        String nextExecutorRoleIds = "";
        // 判断当前是否为提交
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            //发起流程
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
            dto.setBusinessKey(String.valueOf(new Date().getTime()));
            dto.setNextExecuteUserCompanyCode(model.getReceiveCompanyCode());
            dto.setCompleteFirstTask(true);
            list.add(dto);
            actWorkflowBatchDTO.setProcess(list);
            List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
            workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            nextExecutorRoleIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
            nextExecutorUserIds.add(workflowResultDtos.get(0).getNextExecutorUserIds());
            for (WorkflowResultDto processTaskDTO : workflowResultDtos) {
                instanceIdList.add(processTaskDTO.getInstanceId());
                taskIds.add(processTaskDTO.getNextTaskId());
            }
        }

        String finalNextExecutorRoleIds = nextExecutorRoleIds;
        CompanyBo companyBo = commonServiceImpl.getOneCompany(model.getReceiveCompanyCode());
        model.setApplyNo(applyNoList.get(0));
        model.setReceiveCompanyOrgCode(companyBo.getOrgCode());
        model.setCreateUserId(RequestContext.getExeUserId());
        model.setApplyDate(new Date());
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            model.setNextExecutorIds(finalNextExecutorRoleIds);
            model.setInstanceStatus(String.join(",", roleListFirst));
            model.setPromoter(reginParams.getUserModel().getUserId());
            model.setStatus(taskName[0]);
        }
        if (!CollectionUtils.isEmpty(nextExecutorUserIds)) {
            model.setNextExecuteUserIds(nextExecutorUserIds.get(0));
        }
        if (!CollectionUtils.isEmpty(instanceIdList)) {
            model.setInstanceId(instanceIdList.get(0));
            model.setStatus(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
        } else {
            model.setStatus(WorkFlowStatusEnum.UNITCHANGE_SUBMIT.getPass());
        }
        if (!CollectionUtils.isEmpty(taskIds)) {
            model.setNextTaskId(taskIds.get(0));
        }
        model.setSequenceNbr(sequence.nextId());
        model.setCreateDate(new Date());
        model.setCreateUserName(reginParams.getUserModel().getRealName());
        model.setUseRegistCode(String.join("，", registrationNoList));
        model.setEquList(registrationList.get(0).get("equList").toString());
        JgChangeRegistrationUnit registrationUnit = new JgChangeRegistrationUnit();
        BeanUtils.copyProperties(model, registrationUnit);
        setNewUnitInfo(reginParams, registrationUnit);
        JgChangeRegistrationUnitMapper.insert(registrationUnit);

        List<TaskModelDto> modelDtos = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            TaskModelDto taskModelDto = new TaskModelDto();
            TaskMessageDto ta = new TaskMessageDto();
            ta.setInstanceId(registrationUnit.getInstanceId());
            ta.setStatus(registrationUnit.getStatus());
            ta.setPromoter(registrationUnit.getPromoter());
            ta.setNextExecuteUserIds(registrationUnit.getNextExecuteUserIds());
            ta.setSequenceNbr(registrationUnit.getSequenceNbr());
            ta.setNextTaskId(registrationUnit.getNextTaskId());
            taskModelDto.setModel(ta);
            taskModelDto.setFlowCreateDate(new Date());
            taskModelDto.setTaskName(workflowResultDtos.get(0).getNextTaskName());
            taskModelDto.setFlowCode(registrationUnit.getNextTaskId());
            taskModelDto.setTaskContent(this.buildTaskContent(registrationUnit));
            taskModelDto.setTaskCode(registrationUnit.getApplyNo());
            taskModelDto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
            taskModelDto.setRelationId(registrationUnit.getInstanceId());
            taskModelDto.setExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
            taskModelDto.setTaskStatusLabel("未处理");
            taskModelDto.setFlowStatus(commonServiceImpl.getDictionaryCodeByName(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass()));
            taskModelDto.setFlowStatusLabel(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
            taskModelDto.setStartUserId(RequestContext.getExeUserId());
            taskModelDto.setStartUser(workflowResultDtos.get(0).getStartUserName());
            taskModelDto.setStartUserCompanyName(reginParams.getCompany().getCompanyName());
            taskModelDto.setStartDate(new Date());
            taskModelDto.setNextExecuteUser(workflowResultDtos.get(0).getNextExecutorRoleIds());
            modelDtos.add(taskModelDto);
        } else {
            TaskModelDto taskModelDto = new TaskModelDto();
            //行数据
            taskModelDto.setModel(registrationUnit);
            //摘要 按原有规则组装
            taskModelDto.setTaskContent(this.buildTaskContent(registrationUnit));
            //申请单号
            taskModelDto.setTaskCode(registrationUnit.getApplyNo());
            //业务类型枚举code值
            taskModelDto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
            ////业务主键
            taskModelDto.setRelationId(registrationUnit.getSequenceNbr() + "");
            modelDtos.add(taskModelDto);
//            }
        }
        commonServiceImpl.saveExecuteFlowData2Redis(registrationUnit.getInstanceId(), buildInstanceRuntimeData(registrationUnit));
        commonServiceImpl.buildTaskModel(modelDtos);

        List<JgChangeRegistrationUnitEq> jgRelationEquipList = new ArrayList<>();
        deviceList.forEach(device -> {
            JgChangeRegistrationUnitEq unitEq = new JgChangeRegistrationUnitEq();
            if (device.containsKey("USE_ORG_CODE")) {
                unitEq.setRegistrationCertificate(device.getString("USE_ORG_CODE"));//使用登记证主键
            }
            if (device.containsKey("SEQUENCE_NBR")) {
                unitEq.setEquId(device.getString("SEQUENCE_NBR"));//设备主键
            }
            unitEq.setUnitChangeRegistrationId(registrationUnit.getSequenceNbr().toString());//单位变更业务主键
            unitEq.setDeviceInfo(JSONObject.toJSONString(device));//设备信息json
            jgRelationEquipList.add(unitEq);
        });
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        //登记类别
        jgRegistrationHistory.setRegistrationClass("单位变更登记");
        jgRegistrationHistory.setCurrentDocumentId(registrationUnit.getApplyNo());
        //使用登记证历史数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(registrationList));
        //先删除之前设备关系数据，在插入最新设备关系数据
        registrationUnitEqService.getBaseMapper().delete(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>()
                .eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, registrationUnit.getSequenceNbr()));
        registrationUnitEqService.saveBatch(jgRelationEquipList);
        //先删除之前未提交的历史使用登记证信息，在插入最新的使用登记证信息
        registrationHistoryService.getBaseMapper().delete(new LambdaQueryWrapper<JgRegistrationHistory>()
                .eq(JgRegistrationHistory::getCurrentDocumentId, registrationUnit.getApplyNo()));
        registrationHistoryService.save(jgRegistrationHistory);

        if (SUBMIT_TYPE_FLOW.equals(submitType)) {//放在最后面防止前面有异常
            //如果是提交，用于校验设备是否已经在流程中，如果不在标记设备已经在流程中
            CompanyBo company = reginParams.getCompany();
            deviceList.forEach(jsonObject -> EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY)
                    .equipRepeatUsedCheck(String.valueOf(jsonObject.get("SEQUENCE_NBR")),
                            CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                            company.getCompanyCode().split("_")[1] :
                            company.getCompanyCode()));
        }
        return Collections.singletonList(model);
    }

    public boolean canConvertToLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    private void updateHistoryAsync(List<JgChangeRegistrationUnitEq> jgRelationEquipList) {
        jgRelationEquipList.forEach(j -> {
            commonService.saveOrUpdateHistory(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName(),
                    getEquipInfoJson(j.getUnitChangeRegistrationId()), j.getEquId(), j.getUnitChangeRegistrationId());
        });
    }

    private JSONObject getEquipInfoJson(String id) {
        return new JSONObject(getEquipInfo(Long.parseLong(id), new HashMap<>()));
    }


    private void convertField(JgChangeRegistrationUnitDto model) {
        // 处理图片
        if (!ValidationUtil.isEmpty(model.getChangeCertificateList())) {
            model.setChangeCertificate(JSON.toJSONString(model.getChangeCertificateList()));
        }
        // 处理其他附件
        if (!ValidationUtil.isEmpty(model.getOtherAccessoriesList())) {
            model.setOtherAccessories(JSON.toJSONString(model.getOtherAccessoriesList()));
        }
        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }

        String receiveOrgCode = model.getReceiveOrgCode();
        if (!ObjectUtils.isEmpty(receiveOrgCode)) {
            String[] receiveOrgCodeList = receiveOrgCode.split("_");
            if (receiveOrgCodeList.length > 1) {
                model.setReceiveOrgCode(receiveOrgCodeList[0]);
                model.setReceiveCompanyCode(receiveOrgCodeList[0]);
                model.setReceiveOrgName(receiveOrgCodeList[1]);
            }
        }
    }


    @GlobalTransactional(rollbackFor = Exception.class)
    public boolean submit(JgChangeRegistrationUnit notice, String op) {

        AjaxResult ajaxResult = Workflow.taskClient.getTask(notice.getInstanceId());
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskId = dataObject.getString("id");
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        if (!ValidationUtil.isEmpty(notice.getProcessAdvice())) {
            dto.setComment(notice.getProcessAdvice());
        }
        HashMap<String, Object> map = new HashMap<>();
        if (notice.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) || notice.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack())) {
            map.put("approvalStatus", "提交");
        } else {
            map.put("approvalStatus", op);
        }
        dto.setVariable(map);
        //执行流程
        AjaxResult ajaxResult1;
        try {
            ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            if (ajaxResult1.get("code").equals(200)) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            log.error("提交失败：{}", e);
            return false;
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void cancel(JgChangeRegistrationUnitDto noticeDto) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(noticeDto.getInstanceId());
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 撤回校验
            commonServiceImpl.checkForRevocationFlow(noticeDto.getNextTaskId(), noticeDto.getInstanceId());

            String taskCode;
            List<String> roleListNext = new ArrayList<>();
            List<String> roleListAll = new ArrayList<>();
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(noticeDto.getInstanceId());
            String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));

            // 待调整
            taskCode = processTaskDTO.getNextTask().get(0).getKey();
            JgChangeRegistrationUnit changeUnit = this.baseMapper.selectById(noticeDto.getSequenceNbr());
            changeUnit.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            changeUnit.setPromoter("");
            changeUnit.setNextTaskId(nextTaskId);
            changeUnit.setNextExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
            changeUnit.setNextExecutorIds(String.join(",", roleListNext));
            JgChangeRegistrationUnitMapper.updateById(changeUnit);
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(changeUnit));
            jsonObject.put("nextTaskId", changeUnit.getNextTaskId());
            jsonObject.put("nextExecuteUser", changeUnit.getNextExecutorIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
            jsonObject.put("flowStatus", this.getTaskCodeByName(changeUnit.getStatus()));
            jsonObject.put("flowStatusLabel", changeUnit.getStatus());

            commonServiceImpl.rollbackTask(noticeDto.getInstanceId(), jsonObject);

            // redis流程实时数据更新
            commonServiceImpl.saveExecuteFlowData2Redis(noticeDto.getInstanceId(), this.buildInstanceRuntimeData(changeUnit));
            this.delRepeatUseEquipData(changeUnit.getApplyNo(), changeUnit.getStatus(), changeUnit.getNewUseUnitCreditCode());
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public InstanceRuntimeData buildInstanceRuntimeData(JgChangeRegistrationUnit jgChangeRegistrationUnit) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jgChangeRegistrationUnit.getNextExecuteUserIds())
                .promoter(jgChangeRegistrationUnit.getPromoter())
                .nextTaskId(jgChangeRegistrationUnit.getNextTaskId())
                .build();
    }

    /**
     * @param dto
     * @param op          void
     * @param reginParams
     * @description 执行流程
     * @author wangguo
     * @date 2024/7/18 11:00
     **/
    @GlobalTransactional(rollbackFor = Exception.class)
    public void accept(JgChangeRegistrationUnitDto dto, String op, ReginParams reginParams) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(dto.getInstanceId());
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonServiceImpl.checkForExecuteFlow(dto.getNextTaskId(), dto.getInstanceId());

            String[] taskName = new String[]{"已完成"};
            String userId = RequestContext.getExeUserId();
            String taskId = dto.getNextTaskId();
            JgChangeRegistrationUnit registration = this.JgChangeRegistrationUnitMapper.selectById(dto.getSequenceNbr());
            registration.setProcessAdvice(dto.getProcessAdvice());
            List<String> roleListAll = new ArrayList<>();
            ArrayList<String> roleList = new ArrayList<>();

            //组装信息
            TaskResultDTO task = new TaskResultDTO();
            task.setResultCode("approvalStatus");
            task.setTaskId(taskId);
            task.setComment(StringUtils.isEmpty(dto.getProcessAdvice()) ? "" : dto.getProcessAdvice());
            task.setNextExecuteUserCompanyCode(this.getNextUserOrgCode(op, registration));

            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", op);
            if (!ObjectUtils.isEmpty(registration.getInstanceStatus()) &&
                    (registration.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) ||
                            registration.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack()))) {
                map.put("approvalStatus", "提交");
            }
            task.setVariable(map);
            //执行流程
            ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(taskId, task, op);
            String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
            String taskName1 = "";
            String nextTaskId = "";
            this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
            List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
            String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
            if (processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() > 0) {
                taskCode = processTaskDTO.getNextTask().get(0).getKey();
                taskName1 = processTaskDTO.getNextTask().get(0).getName();
                nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            }

            registration.setStatus(taskName[0]);
            if ("0".equals(op)) {
                if (roleList.isEmpty()) {
                    registration.setStatus(taskName[0]);
                    registration.setAuditPassDate(new Date());
                    // 生成新的使用登记编号，使用登记证  修改设备的使用登记信息表，使用单位名称，使用单位统一信用代码，使用登记证编号，更新ES
                    LambdaQueryWrapper<JgChangeRegistrationUnitEq> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, dto.getSequenceNbr());
                    List<JgChangeRegistrationUnitEq> jgChangeRegistrationUnitEqs = JgChangeRegistrationUnitEqMapper.selectList(queryWrapper);
                    for (JgChangeRegistrationUnitEq jgChangeRegistrationUnitEq : jgChangeRegistrationUnitEqs) {
                        String equipId = jgChangeRegistrationUnitEq.getEquId();
                        LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
                        queryWrapper1.eq(OtherInfo::getRecord, equipId);
                        OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);
                        if (ObjectUtils.isNotEmpty(tzsJgOtherInfo)) {
                            LambdaQueryWrapper<UseInfo> queryWrapper2 = new LambdaQueryWrapper<>();
                            queryWrapper2.eq(UseInfo::getRecord, equipId);
                            UseInfo useInfo = useInfoMapper.selectOne(queryWrapper2);
                            if (ObjectUtils.isNotEmpty(useInfo)) {
                                useInfo.setUseUnitName(registration.getNewUseUnitName());
                                useInfo.setUseUnitCreditCode(registration.getNewUseUnitCreditCode());
                                useInfoMapper.updateById(useInfo);
                            }
                            //修改ES中使用单位信息和使用单位代码
                            Map<String, Map<String, Object>> resultMap = new HashMap<>();
                            Map<String, Object> map1 = new HashMap<>();
                            String[] companyCode = registration.getNewUseUnitCreditCode().split("_");
                            map1.put("USE_UNIT_CREDIT_CODE", companyCode.length > 1 ? companyCode[1] : registration.getNewUseUnitCreditCode());
                            map1.put("USE_UNIT_NAME", registration.getNewUseUnitName());
                            map1.put("REC_DATE", new Date());// 更新时间，设备筛选时排在前面 bug-21476
                            resultMap.put(equipId, map1);
                            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
                            //修改各类告知列表，置为废弃
                            this.updataInvalidStatusByHistory(equipId, registration.getApplyNo());
                        }
                    }
                    registration.setNextTaskId(nextTaskId);
                    updateTaskModel(registration, op);
                    //新增使用登记证和设备变更记录
                    this.saveRecord(registration);
                    JgRegistrationHistory history = registrationHistoryService.lambdaQuery()
                            .eq(JgRegistrationHistory::getCurrentDocumentId, registration.getApplyNo())
                            .eq(JgRegistrationHistory::getIsDelete, false)
                            .one();
                    JSONArray historyJson = JSON.parseArray(history.getChangeData());
                    List<String> ids = historyJson.stream().map(v -> JSON.parseObject(v.toString()).getString("sequenceNbr")).collect(Collectors.toList());
                    List<JgUseRegistrationManage> list = useRegistrationManageService.lambdaQuery().in(BaseEntity::getSequenceNbr, ids).list();
                    for (JgUseRegistrationManage registrationManage : list) {
                        //修改使用登记证管理使用单位地址、使用单位代码、接收机构、接收机构公司代码、办理日期、使用单位地址
                        registrationManage.setUseUnitName(registration.getNewUseUnitName());
                        registrationManage.setUseUnitCreditCode(registration.getNewUseUnitCreditCode());
                        registrationManage.setReceiveOrgName(registration.getReceiveOrgName());
                        registrationManage.setReceiveCompanyCode(registration.getReceiveOrgCode());
                        registrationManage.setAuditPassDate(registration.getAuditPassDate());
                        if (!ObjectUtils.isEmpty(registration.getNewUseUnitCreditCode())) {//回填新单位地址
                            TzBaseEnterpriseInfo useCodeResult = tzBaseEnterpriseInfoMapper.selectOne(new QueryWrapper<TzBaseEnterpriseInfo>().eq("use_unit_code", registration.getNewUseUnitCreditCode()));
                            if (useCodeResult != null) {
                                registrationManage.setUseUnitAddress(useCodeResult.getAddress());
                            }
                        }
                    }
                    useRegistrationManageService.updateBatchById(list);
                } else {
                    registration.setNextExecutorIds(String.join(",", roleList));
                    if (!ObjectUtils.isEmpty(registration.getInstanceStatus())) {
                        registration.setInstanceStatus(registration.getInstanceStatus() + "," + String.join(",", roleList));
                    } else {
                        registration.setInstanceStatus(String.join(",", roleList));
                    }
                    registration.setPromoter(userId);
                    registration.setNextExecuteUserIds(nextUserIds);
                    registration.setNextTaskId(nextTaskId);
                    registration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                    executeOneStep(registration, taskName1, nextUserIds, op);
                }
            } else {
                registration.setPromoter("");
                registration.setNextExecutorIds(String.join(",", roleList));
                registration.setNextTaskId(nextTaskId);
                registration.setNextExecuteUserIds(nextUserIds);
                registration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                executeOneStep(registration, taskName1, nextUserIds, op);
            }
            JgChangeRegistrationUnitMapper.updateById(registration);

            // redis流程实时数据更新
            commonServiceImpl.saveExecuteFlowData2Redis(dto.getInstanceId(), this.buildInstanceRuntimeData(registration));
            this.delRepeatUseEquipData(registration.getApplyNo(), registration.getStatus(), registration.getNewUseUnitCreditCode());
        } catch (InterruptedException e) {
            e.printStackTrace();
            throw new BadRequest("数据异常，请联系管理员");
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    /**
     * 删除 redis校验重复引用设备的数据
     */
    private void delRepeatUseEquipData(String applyNo, String status, String companyCode) {
        JgRegistrationHistory history = registrationHistoryService.lambdaQuery()
                .eq(JgRegistrationHistory::getCurrentDocumentId, applyNo)
                .eq(JgRegistrationHistory::getIsDelete, false)
                .one();
        // 获取使用登记证列表
        JSONArray registrationList = JSON.parseArray(history.getChangeData());
        if (CollectionUtils.isEmpty(registrationList)) {
            return;
        }
        List<Long> registrationIdList = new ArrayList<>();
        //根据使用登记证查询设备
        for (Object o : registrationList) {
            JSONObject parseObject = JSON.parseObject(o.toString());
            if (parseObject.containsKey("sequenceNbr") && ObjectUtils.isNotEmpty(parseObject.get("sequenceNbr")) &&
                    canConvertToLong(parseObject.get("sequenceNbr").toString())) {
                registrationIdList.add(Long.parseLong(parseObject.get("sequenceNbr").toString()));
            }
        }
        if (CollectionUtils.isEmpty(registrationIdList)) {
            return;
        }
        List<JSONObject> equList = registrationManageService.queryEquByCertificateSeqList(registrationIdList);
        // 获取单位变更设备列表
        if (CollectionUtils.isEmpty(equList)) {
            return;
        }
        List<String> records = new ArrayList<>();
        for (JSONObject jsonObject : equList) {
            records.add(jsonObject.getString("SEQUENCE_NBR"));
        }
        if (NOT_FLOWING_STATE.contains(status)) {
            EquipUsedCheckStrategyContext.getUsedStrategy(PROCESS_DEFINITION_KEY)
                    .delDataForCheckEquipRepeatUsed(records, companyCode);
        }
    }

    private Integer getTaskCodeByName(String auditStatus) {
        return commonServiceImpl.getDictionaryCodeByName(auditStatus);
    }


    /**
     * 修改各类告知列表，置为废弃
     *
     * @param equId           设备id
     * @param equipTransferId 当前告知单Id
     */
    public void updataInvalidStatusByHistory(String equId, String equipTransferId) {
        //改造变更登记
        jgChangeRegistrationReformEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //移装变更登记
        jgChangeRegistrationTransferEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //使用登记
        jgUseRegistrationEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //单位变更登记
        jgChangeRegistrationUnitEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //更名变更登记
        jgChangeRegistrationNameEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
    }


    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }


    /**
     * 导出使用登记证
     *
     * @param sequenceNbr
     */
    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response, String printType) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        //查询移装变更详情
        JgChangeRegistrationUnit transfer = this.getById(sequenceNbr);
        LambdaQueryWrapper<JgChangeRegistrationUnitEq> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, transfer.getSequenceNbr());
        JgChangeRegistrationUnitEq jgChangeRegistrationUnitEq = JgChangeRegistrationUnitEqMapper.selectOne(queryWrapper);
        if (ValidationUtil.isEmpty(transfer) || ValidationUtil.isEmpty(jgChangeRegistrationUnitEq)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        //是否废弃
        exportParamsMap.put("isInvalid", ValidationUtil.isEmpty(jgChangeRegistrationUnitEq.getIsInvalid()) ? "0" : jgChangeRegistrationUnitEq.getIsInvalid());
        //登记机关
        exportParamsMap.put("receiveOrgName", transfer.getReceiveOrgName());
        //使用登记证编号
        exportParamsMap.put("useRegistrationCode", ValidationUtil.isEmpty(transfer.getUseRegistCode()) ? "" : transfer.getUseRegistCode());
        //使用单位名称
        exportParamsMap.put("useUnitName", transfer.getNewUseUnitName());
        //监管码
        LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(OtherInfo::getRecord, jgChangeRegistrationUnitEq.getEquId());
        OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);
        exportParamsMap.put("supervisoryCode", tzsJgOtherInfo.getSupervisoryCode());
        getAuditPassedDate(transfer.getAuditPassDate(), exportParamsMap);
        //查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", jgChangeRegistrationUnitEq.getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            //设备种类、类别、品种
            String equList = registerInfo.getEquList();//设备种类
            String equCategory = registerInfo.getEquCategory();//设备类别
            String equDefine = registerInfo.getEquDefine();//设备品种
            List<EquipmentCategory> categoryList0 = commonService.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList1)) {
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList1)) {
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (!ValidationUtil.isEmpty(equDefine)) {
                List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList2)) {
                    exportParamsMap.put("equDefine", categoryList2.get(0).getName());
                }
            }
            //设备代码
            exportParamsMap.put("equCode", registerInfo.getEquCode());
        }

        //单位内部编码
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(jgChangeRegistrationUnitEq.getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());

            String fullAddress = "";
            String province = ValidationUtil.isEmpty(useInfo.getProvinceName()) ? "" : useInfo.getProvinceName();
            String city = ValidationUtil.isEmpty(useInfo.getCityName()) ? "" : useInfo.getCityName();
            String county = ValidationUtil.isEmpty(useInfo.getCountyName()) ? "" : useInfo.getCountyName();
            String street = ValidationUtil.isEmpty(useInfo.getStreetName()) ? "" : useInfo.getStreetName();
            String address = ValidationUtil.isEmpty(useInfo.getAddress()) ? "" : useInfo.getAddress();
            fullAddress = province + city + county + street + address;
            exportParamsMap.put("fullAddress", fullAddress);
        }
        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(jgChangeRegistrationUnitEq.getEquId());
        //产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        //调用生成使用登记证
        exportParamsMap.put("excelType", "变更登记");
        exportParamsMap.put("tableName", "特种设备单位变更登记");
        exportParamsMap.put("applyNo", transfer.getApplyNo());
        if ("0".equals(printType)) {
            //调用生成使用登记证
            commonService.generateCertificateReport(exportParamsMap, response);
        } else {
            commonService.generatePdfPrint(exportParamsMap, response);
        }
    }


    private String buildTaskContent(JgChangeRegistrationUnit obj) {
        //发起电梯登记业务申请，【申请单号SYDJ202400001】
        return "发起了【单位变更登记】业务申请，【申请单号" + obj.getApplyNo() + "】";
    }

    private String buildRecordContent(JgChangeRegistrationUnit obj) {
        FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.queryByUserId(obj.getCreateUserId());
        //张三办理了【单位变更】 ，单号【DWBG202407050001】，原恒星电梯单位变更为新恒星电梯有限公司，办理日期2024-07-05
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日");

        return obj.getUseUnitName()+"的"+agencyUserModelFeignClientResult.getResult().getRealName() + "办理了【单位变更登记】，单号【"
                + obj.getApplyNo() + "】，原" + obj.getUseUnitName() + "变更为新"
                + obj.getNewUseUnitName() + "，申请日期" + simpleDateFormat.format(obj.getCreateDate());
    }

    private void createTaskModel(JgChangeRegistrationUnit dto, String taskName, String submitType, String nextUserIds) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if ("1".equals(submitType)) {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(dto.getApplyDate());
            taskModelDto.setTaskName(taskName);
            taskModelDto.setTaskCode(dto.getApplyNo());
            taskModelDto.setTaskContent(this.buildTaskContent(dto));
            taskModelDto.setTaskDesc("");
            taskModelDto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
            taskModelDto.setRelationId(dto.getInstanceId());
            taskModelDto.setExecuteUserIds(nextUserIds);
            taskModelDto.setFlowStatus(this.getTaskStatusByName(dto.getStatus()));
            taskModelDto.setFlowStatusLabel(dto.getStatus());
            taskModelDto.setTaskStatusLabel(dto.getAuditStatus());
            taskModelDto.setStartUserId(RequestContext.getExeUserId());
            taskModelDto.setStartUser(reginParams.getUserModel().getRealName());
            taskModelDto.setStartUserCompanyName(dto.getUseUnitName());
            taskModelDto.setNextExecuteUser(dto.getNextExecutorIds());
            taskModelDto.setStartDate(dto.getCreateDate());
            TaskMessageDto obj = new TaskMessageDto();
            obj.setInstanceId(dto.getInstanceId());
            obj.setStatus(dto.getStatus());
            obj.setPromoter(dto.getPromoter());
            obj.setNextExecuteUserIds(dto.getNextExecuteUserIds());
            obj.setSequenceNbr(dto.getSequenceNbr());
            obj.setNextTaskId(dto.getNextTaskId());
            taskModelDto.setModel(obj);
            commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
        }
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    private void executeOneStep(JgChangeRegistrationUnit jgChangeRegistrationName, String taskName, String nextUserIds, String operate) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(jgChangeRegistrationName, operate);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskCode(jgChangeRegistrationName.getApplyNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(jgChangeRegistrationName.getInstanceId());
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        taskV2Model.setTaskStatus(this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        taskV2Model.setTaskStatusLabel(jgChangeRegistrationName.getStatus());
        taskV2Model.setFlowStatus(this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        taskV2Model.setFlowStatusLabel(jgChangeRegistrationName.getStatus());
        taskV2Model.setExecuteUserIds(nextUserIds);
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(jgChangeRegistrationName.getNextExecutorIds());
        if (jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject())) {
            modelDto.setPageType("edit");
        }
        TaskMessageDto obj = new TaskMessageDto();
        obj.setInstanceId(jgChangeRegistrationName.getInstanceId());
        obj.setStatus(jgChangeRegistrationName.getStatus());
        obj.setPromoter(jgChangeRegistrationName.getPromoter());
        obj.setNextExecuteUserIds(jgChangeRegistrationName.getNextExecuteUserIds());
        obj.setSequenceNbr(jgChangeRegistrationName.getSequenceNbr());
        obj.setNextTaskId(jgChangeRegistrationName.getNextTaskId());
        modelDto.setModel(obj);
        // 再插入新代办、数据待定
        commonServiceImpl.buildTaskModel(Collections.singletonList(modelDto));
    }


    private TaskV2Model updateTaskModel(JgChangeRegistrationUnit jgChangeRegistrationName, String operate) {
        Map<String, Object> params = new HashMap<>();
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        params.put("relationId", jgChangeRegistrationName.getInstanceId());
        params.put("taskStatus", flowStatusEnum.getCode());
        params.put("taskStatusLabel", flowStatusEnum.getName());
        params.put("flowStatus", this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        params.put("flowStatusLabel", jgChangeRegistrationName.getStatus());
        params.put("model", jgChangeRegistrationName);
        return commonServiceImpl.updateTaskModel(params);
    }

    private FlowStatusEnum getTaskStatus(String operate) {
        if ("0".equals(operate)) {
            return FlowStatusEnum.TO_BE_FINISHED;
        } else {
            return FlowStatusEnum.REJECTED;
        }
    }


    private String getNextUserOrgCode(String operate, JgChangeRegistrationUnit jgChangeRegistrationName) {
        if ("0".equals(operate)) {
            // 执行通过节点，单位code为接收机构单位信息
            return jgChangeRegistrationName.getReceiveOrgCode();
        }
        if (jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getPass())
                || jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getReject())
                || jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getRollBack())) {
            // 驳回且当前节点为一键节点时，单位code为发起人单位信息
            return jgChangeRegistrationName.getUseUnitCreditCode();
        }
        // 2、3级驳回时，单位code为接收单位code
        return jgChangeRegistrationName.getReceiveOrgCode();
    }

    private Integer getTaskStatusByName(String auditStatus) {
        return commonServiceImpl.getDictionaryCodeByName(auditStatus);
    }

    @Override
    public boolean beforeCheck(JgChangeRegistrationUnit jgChangeRegistrationUnit) {
        return jgChangeRegistrationUnit.getInstanceId() != null && !jgChangeRegistrationUnit.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) &&!jgChangeRegistrationUnit.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName());
    }

    @Override
    public void compensate(JgChangeRegistrationUnit jgChangeRegistrationUnit) {
        commonServiceImpl.saveExecuteFlowData2Redis(jgChangeRegistrationUnit.getInstanceId(), this.buildInstanceRuntimeData(jgChangeRegistrationUnit));
    }

    /**
     * bug24304脏数据处理（单位变更登记一勾选过多，部分变更设备失败，现在将变更失败的设备变更过去）
     */
    @Transactional(rollbackFor = Exception.class)
    public void bug24304Handle(String businessType, String applyNos) {
        /* // 查询单位变更登记的历史数据
        List<JgRegistrationHistory> historyList = jgRegistrationHistoryMapper.selectList(new LambdaQueryWrapper<JgRegistrationHistory>()
                .eq(JgRegistrationHistory::getRegistrationClass, "单位变更登记"));
        // 过滤出异常数据
        List<JgRegistrationHistory> targetHistory = historyList
                .stream()
                .filter(item -> {
                    try {
                        return JSONArray.parseArray(item.getChangeData()).size() > 10;
                    } catch (Exception ex) {
                        return false;
                    }
                })
                .collect(Collectors.toList()); */

        List<String> applyNoList = Arrays.asList(applyNos.split(","));
        switch (businessType) {
            case "1":
                changeRegistrationUnitHandler(applyNoList);
                break;
            case "2":
                scrapCancelHandler(applyNoList);
                break;
            default:
                break;
        }

    }

    /**
     * 注销-数据处理
     * @param applyNoList 申请单号list
     */
    private void scrapCancelHandler(List<String> applyNoList){
        applyNoList.forEach(applyNo ->{
            // 查询注销数据
            JgScrapCancel scrapCancel = jgScrapCancelMapper.selectOne(new LambdaQueryWrapper<JgScrapCancel>()
                    .eq(JgScrapCancel::getApplyNo, applyNo));
            // 查询注销的历史数据
            JgRegistrationHistory history = jgRegistrationHistoryMapper.selectOne(new LambdaQueryWrapper<JgRegistrationHistory>()
                    .eq(JgRegistrationHistory::getRegistrationClass, "注销")
                    .eq(JgRegistrationHistory::getCurrentDocumentId,scrapCancel.getSequenceNbr()));
            // 查询已经入库的设备id
            List<String> inEqTableEquId = jgScrapCancelEqMapper.selectList(new LambdaQueryWrapper<JgScrapCancelEq>()
                            .eq(JgScrapCancelEq::getEquipTransferId, scrapCancel.getSequenceNbr()))
                    .stream()
                    .map(JgScrapCancelEq::getEquId)
                    .collect(Collectors.toList());
            // 查询单子下的所有使用登记证的seq
            List<Long> certificateSeq = JSONArray.parseArray(JSON.toJSONString(JSONObject.parseObject(history.getChangeData()).get("certificates"))).stream().map(item -> Long.valueOf((String) JSONObject.parseObject(JSONObject.toJSONString(item)).get("sequenceNbr"))).collect(Collectors.toList());
            // 使用登记证下的所有设备
            List<JSONObject> equJSONList = registrationManageService.queryEquByCertificateSeqList(certificateSeq);
            // 过滤出未入库的设备
            List<JSONObject> toBeProcessedEq = equJSONList.stream().filter(item -> !inEqTableEquId.contains(item.getString("SEQUENCE_NBR"))).collect(Collectors.toList());
            // 未入库的设备record
            List<String> toBeProcessedEqRecord = toBeProcessedEq.stream().map(item -> String.valueOf(item.get("SEQUENCE_NBR"))).collect(Collectors.toList());
            // 保存到对应的eq表
            ArrayList<JgScrapCancelEq> jgScrapCancelEqs = new ArrayList<>();
            toBeProcessedEqRecord.forEach(eq ->{
                IdxBizJgRegisterInfo jgRegisterInfo = idxBizJgRegisterInfoService.getBaseMapper().selectOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, eq));
                JgScrapCancelEq cancelEq = new JgScrapCancelEq();
                cancelEq.setEquipTransferId(String.valueOf(scrapCancel.getSequenceNbr()));
                cancelEq.setEquId(eq);
                cancelEq.setIsDelete(Boolean.FALSE);
                cancelEq.setEquCode(jgRegisterInfo.getEquCode());
                cancelEq.setUseRegistrationCode(jgRegisterInfo.getUseOrgCode());
                jgScrapCancelEqs.add(cancelEq);
                jgScrapCancelEqMapper.insert(cancelEq);
            });
            // 修改监督管理信息
            SuperviseInfo superviseInfo = new SuperviseInfo();
            superviseInfo.setOrgBranchCode("");
            superviseInfo.setOrgBranchName("");
            LambdaQueryWrapper<SuperviseInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(SuperviseInfo::getRecord, toBeProcessedEqRecord);
            superviseInfoMapper.update(superviseInfo, wrapper);
            // 修改设备状态
            idxBizJgUseInfoMapper.batchUpdateUseInfo(toBeProcessedEqRecord, EquimentEnum.ZHUXIAO.getCode());
            // 修改证管理表中的证的状态
            List<JgUseRegistrationManage> jgUseRegistrationManages = jgUseRegistrationManageMapper.selectList(new LambdaQueryWrapper<JgUseRegistrationManage>()
                    .in(JgUseRegistrationManage::getSequenceNbr, certificateSeq)
                    .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName()));
            LambdaUpdateWrapper<JgUseRegistrationManage> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(JgUseRegistrationManage::getSequenceNbr,jgUseRegistrationManages.stream().map(BaseEntity::getSequenceNbr).collect(Collectors.toList()));
            updateWrapper.set(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIZHUXIAO.getName());
            jgUseRegistrationManageMapper.update(null, updateWrapper);
            // 修改es数据
            Map<String, Object> map = new HashMap<>();
            map.put("ORG_BRANCH_CODE", "");
            map.put("ORG_BRANCH_NAME", "");
            map.put("EQU_STATE", String.valueOf(EquimentEnum.ZHUXIAO.getCode()));
            Map<String, Map<String, Object>> resultMap = new HashMap<>();
            for (String equipId : toBeProcessedEqRecord) {
                resultMap.put(equipId, map);
            }
            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
            // 添加流水记录
            String userId = scrapCancel.getCreateUserId();
            String realName = Privilege.agencyUserClient.queryByUserId(userId).getResult().getRealName();
            String content = scrapCancel.getUseUnitName() + "的" + realName + "办理了【" + CancelTypeEnum.getNameByType(scrapCancel.getCancelType()) + "】" +
                    "单号【" + scrapCancel.getApplyNo() + "】，办理日期" + DateUtils.getDateNowShortStr();
            List<JgCertificateChangeRecord> certificateChangeRecords = new ArrayList<>();
            List<JgCertificateChangeRecordEq> changeRecordEqList = new ArrayList<>();
            Optional<JgCertificateChangeRecord> first = certificateChangeRecordService.getBaseMapper().selectList(new LambdaQueryWrapper<JgCertificateChangeRecord>().eq(JgCertificateChangeRecord::getApplyNo, applyNo)).stream().findFirst();
            for (JgUseRegistrationManage jgUseRegistrationManage : jgUseRegistrationManages) {
                long seq = sequence.nextId();
                JgCertificateChangeRecord changeRecord = new JgCertificateChangeRecord();
                changeRecord.setSequenceNbr(seq);
                changeRecord.setApplyNo(scrapCancel.getApplyNo());
                changeRecord.setReceiveOrgName(scrapCancel.getReceiveOrgName());
                changeRecord.setAuditPassDate(new Date());
                changeRecord.setRegType(CancelTypeEnum.getNameByType(scrapCancel.getCancelType()));
                changeRecord.setRegDate(scrapCancel.getCreateDate());
                changeRecord.setChangeContent(content);
                changeRecord.setUseRegistrationCode(jgUseRegistrationManage.getUseRegistrationCode());
                changeRecord.setReceiveCompanyCode(scrapCancel.getReceiveOrgCode());
                changeRecord.setUseUnitCreditCode(scrapCancel.getUseUnitCode());
                changeRecord.setUseUnitName(scrapCancel.getUseUnitName());
                changeRecord.setEquCategory(jgUseRegistrationManage.getEquCategoryCode());
                changeRecord.setCreateDate(new Date());
                first.ifPresent(item -> changeRecord.setRoutePath(item.getRoutePath()));
                changeRecord.setCreateUserId(scrapCancel.getCreateUserId());
                changeRecord.setCertificateNo(jgUseRegistrationManage.getCertificateNo());
                certificateChangeRecords.add(changeRecord);
                jgScrapCancelEqs.stream().filter(eq -> eq.getUseRegistrationCode().equals(jgUseRegistrationManage.getUseRegistrationCode())).forEach(e -> {
                    JgCertificateChangeRecordEq changeRecordEq = new JgCertificateChangeRecordEq();
                    changeRecordEq.setChangeRecordId(changeRecord.getSequenceNbr().toString()); // 登记证记录主键
                    changeRecordEq.setEquId(e.getEquId()); // 设备主键
                    changeRecordEq.setProductCode(e.getEquCode()); // 设备代码
                    changeRecordEqList.add(changeRecordEq);
                });
            }
            if (!certificateChangeRecords.isEmpty()) {
                certificateChangeRecordService.saveBatch(certificateChangeRecords);
            }
            if (!changeRecordEqList.isEmpty()) {
                jgCertificateChangeRecordEqServiceImpl.saveBatch(changeRecordEqList);
            }
        });
    }

    /**
     * 单位变更数据处理
     *
     * @param applyNoList 申请编号list
     */
    private void changeRegistrationUnitHandler(List<String> applyNoList) {
        applyNoList.forEach(applyNo ->{
            // 查询单位变更登记的历史数据
            JgRegistrationHistory history = jgRegistrationHistoryMapper.selectOne(new LambdaQueryWrapper<JgRegistrationHistory>()
                    .eq(JgRegistrationHistory::getRegistrationClass, "单位变更登记")
                    .eq(JgRegistrationHistory::getCurrentDocumentId,applyNo));
            // 查询变更数据
            JgChangeRegistrationUnit registrationUnit = this.baseMapper.selectOne(new LambdaQueryWrapper<JgChangeRegistrationUnit>()
                    .eq(JgChangeRegistrationUnit::getApplyNo, history.getCurrentDocumentId()));
            // 查询已经入库的设备id
            List<String> inEqTableEquId = jgChangeRegistrationUnitEqMapper.selectList(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>()
                            .eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, registrationUnit.getSequenceNbr()))
                    .stream()
                    .map(JgChangeRegistrationUnitEq::getEquId)
                    .collect(Collectors.toList());

            // 查询单子下的所有使用登记证的seq
            List<Long> certificateSeq = JSONArray.parseArray(history.getChangeData()).stream().map(item -> Long.valueOf((String) JSONObject.parseObject(JSONObject.toJSONString(item)).get("sequenceNbr"))).collect(Collectors.toList());
            // 使用登记证下的所有设备
            List<JSONObject> equJSONList = registrationManageService.queryEquByCertificateSeqList(certificateSeq);
            // 过滤出未入库的设备
            List<JSONObject> toBeProcessedEq = equJSONList.stream().filter(item -> !inEqTableEquId.contains(item.getString("SEQUENCE_NBR"))).collect(Collectors.toList());
            // 将未入库设备 保存到eq表
            this.changeRegistrationUnitSaveLackEqu(toBeProcessedEq, registrationUnit);
            // 将未入库设备 更新es和otherInfo表的使用单位信息
            this.changeRegistrationUnitUpdateLackEquForES(toBeProcessedEq, registrationUnit);
            this.changeRegistrationUnitUpdateLackEquForUseInfo(toBeProcessedEq, registrationUnit);
        });
    }

    /**
     * 单位变更-保存漏掉的设备
     */
    public void changeRegistrationUnitSaveLackEqu(List<JSONObject> deviceList, JgChangeRegistrationUnit registrationUnit) {
        List<JgChangeRegistrationUnitEq> jgRelationEquipList = new ArrayList<>();
        deviceList.forEach(device -> {
            JgChangeRegistrationUnitEq unitEq = new JgChangeRegistrationUnitEq();
            if (device.containsKey("USE_ORG_CODE")) {
                unitEq.setRegistrationCertificate(device.getString("USE_ORG_CODE"));//使用登记证主键
            }
            if (device.containsKey("SEQUENCE_NBR")) {
                unitEq.setEquId(device.getString("SEQUENCE_NBR"));//设备主键
            }
            unitEq.setUnitChangeRegistrationId(registrationUnit.getSequenceNbr().toString());//单位变更业务主键
            unitEq.setDeviceInfo(JSONObject.toJSONString(device));//设备信息json
            jgRelationEquipList.add(unitEq);
        });
        registrationUnitEqService.saveBatch(jgRelationEquipList);
    }
    /**
     * 单位变更-修改es漏掉的设备
     */
    public void changeRegistrationUnitUpdateLackEquForES(List<JSONObject> deviceList, JgChangeRegistrationUnit registration) {
        deviceList.forEach(device -> {
            Map<String, Map<String, Object>> resultMap = new HashMap<>();
            Map<String, Object> map1 = new HashMap<>();
            String[] companyCode = registration.getNewUseUnitCreditCode().split("_");
            map1.put("USE_UNIT_CREDIT_CODE", companyCode.length > 1 ? companyCode[1] : registration.getNewUseUnitCreditCode());
            map1.put("USE_UNIT_NAME", registration.getNewUseUnitName());
            map1.put("REC_DATE", registration.getCreateDate());
            resultMap.put(device.getString("SEQUENCE_NBR"), map1);
            tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
        });
    }
    /**
     * 单位变更-修改使用信息表中漏掉的设备
     */
    public void changeRegistrationUnitUpdateLackEquForUseInfo(List<JSONObject> deviceList, JgChangeRegistrationUnit registration) {
        deviceList.forEach(device -> {
            LambdaQueryWrapper<UseInfo> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UseInfo::getRecord, device.getString("SEQUENCE_NBR"));
            UseInfo useInfo = useInfoMapper.selectOne(queryWrapper);
            if (ObjectUtils.isNotEmpty(useInfo)) {
                useInfo.setUseUnitName(registration.getNewUseUnitName());
                useInfo.setUseUnitCreditCode(registration.getNewUseUnitCreditCode());
                useInfoMapper.updateById(useInfo);
            }
        });
    }
}