package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.JyjcInspectionApplicationDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
public interface JYJCStatisticsMapper extends BaseMapper {

    /**
     * 检验机构总量统计
     *
     * @param orgCode    区域对应的orgCode
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllRegInspectCompany(@Param("orgCode") String orgCode, @Param("regionCode") String regionCode);

    /**
     * 第三方检验机构数量（除去法定名单就是第三方）
     *
     * @param orgCode    区域对应的orgCode
     * @param legalCmc   法定的检验机构名单
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllRegThirdInspectCompany(@Param("orgCode") String orgCode, @Param("legalCmc") List<String> legalCmc, @Param("regionCode") String regionCode);

    /**
     * 业务开通机构数量
     *
     * @param orgCode    区域对应的orgCode
     * @param regionCode 区域行政区划编码
     * @return 检验机构总量
     */
    Long countAllOpenBizInspectCompany(@Param("orgCode") String orgCode, @Param("regionCode") String regionCode);

    /**
     * 按照地区过滤检验检测信息
     *
     * @param page    分页信息
     * @param dto     过滤条件
     * @param orgCode 区域
     * @return 按照所选区域过滤报检信息
     */
    Page<JyjcInspectionApplicationDto> queryForInspectAppPageList(@Param("page") Page<JyjcInspectionApplicationDto> page, @Param("dto") JyjcInspectionApplicationDto dto, @Param("orgCode") String orgCode);

    /**
     * 查询资源附件
     * @param applicationSeq
     * @return
     */
    List<Map<String,Object>> getDataByApplicationSeq(Long applicationSeq);

    Page<Map<String, Object>> inspectionTimelinessTopXXPage(@Param("page") Page<Map<String, Object>> page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long inspectionCount(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Long inspectionFinishCount(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);
}
