package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.JyjcInspectionApplicationDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.InspectionTimelinesDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.PublicityInspectOrgInfoDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.JYJCDPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "大屏统-总览及检验检测统计API")
@RequestMapping("/dp/jy")
public class JYJCDPStatisticsController {


    private JYJCDPStatisticsServiceImpl statisticsService;

    public JYJCDPStatisticsController(JYJCDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧检验检测次数统计", notes = "按照维度设备种类、检验类型进行统计")
    @PostMapping(value = "/inspectTime/count/byEquListAndInspectType")
    public ResponseModel<Map<String, Object>> inspectTimeCountByTypeAndEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCountByTypeAndEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏8大类-气瓶检验检测次数统计", notes = "气瓶检验检测次数统计")
    @PostMapping(value = "/inspectTimeCount")
    public ResponseModel<Map<String, Object>> inspectTimeCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCount(dpFilterParamDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-左侧检验检测人员统计", notes = "大屏-检验检测-左侧检验检测人员统计")
    @PostMapping(value = "/person/count")
    public ResponseModel<Map<String, Object>> inspectPersonCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectPersonCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-各检验类型业务数量统计", notes = "大屏-检验检测-各检验类型业务数量统计")
    @PostMapping(value = "/allApp/countByType")
    public ResponseModel<Map<String, Object>> inspectBizNumCountByType(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryAllFlowingAndFinishedInspectApp(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-各检验类型待检数量统计", notes = "大屏-检验检测-各检验类型待检数量统计")
    @PostMapping(value = "/pendingApp/countByType")
    public ResponseModel<Map<String, Object>> queryAllFlowingAndFinishedInspectApp(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryAllPendingResultInspectApp(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-各检验类型业务数量统计/待检数量统计（新）", notes = "大屏-检验检测-各检验类型业务数量统计/待检数量统计（新）")
    @PostMapping(value = "/queryAllInspectApp")
    public ResponseModel<Map<String, Object>> queryAllInspectApp(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryAllInspectApp(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-近30日业务办理量/办结率统计", notes = "大屏-检验检测-近30日业务办理量/办结率统计")
    @PostMapping(value = "/endRate")
    public ResponseModel<Map<String, Object>> endRate(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.endRate(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-近30日业务办理量/办结率统计下钻图表", notes = "大屏-检验检测-近30日业务办理量/办结率统计下钻图表")
    @PostMapping(value = "/endRateDetail")
    public ResponseModel<Map<String, Object>> endRateDetail(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.endRateDetail(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-近30日业务办理量/办结率统计下钻列表", notes = "大屏-检验检测-近30日业务办理量/办结率统计下钻列表")
    @PostMapping(value = "/endRateList")
    public ResponseModel<Page<Map<String, Object>>> endRateList(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                          @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                          @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current,size);
        return ResponseHelper.buildResponse(statisticsService.endRateList(dpFilterParamForDetailDto,page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-近30日业务办理量/办结率统计下钻类型", notes = "大屏-检验检测-近30日业务办理量/办结率统计下钻类型")
    @PostMapping(value = "/endRateType")
    public ResponseModel<List<Map<String, Object>>> endRateType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.endRateType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-近30日业务办理量/办结率统计下钻筛选类型", notes = "大屏-检验检测-近30日业务办理量/办结率统计下钻筛选类型")
    @PostMapping(value = "/endRateSearch")
    public ResponseModel<Map<String,List<Map<String,Object>>>> endRateSearch(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.endRateSearch(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-按机构进行检验时效统计Top10排名", notes = "大屏-检验检测-按机构进行检验时效统计Top10排名")
    @PostMapping(value = "/timeliness/top")
    public ResponseModel<List<InspectionTimelinesDto>> inspectionTimelinessTopXX(@RequestParam(required = false, defaultValue = "10") String top, @Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionTimelinessTopXX(top, dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-按机构进行检验时效统计Top10排名下钻图表", notes = "大屏-检验检测-按机构进行检验时效统计Top10排名下钻图表")
    @PostMapping(value = "/timeliness/topChart")
    public ResponseModel<Map<String, Object>> inspectionTimelinessTopXXChart(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectionTimelinessTopXXChart(dpFilterParamForDetailDto));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-按机构进行检验时效统计Top10排名下钻列表", notes = "大屏-检验检测-按机构进行检验时效统计Top10排名下钻列表")
    @PostMapping(value = "/timeliness/topPage")
    public ResponseModel<Page<Map<String, Object>>> inspectionTimelinessTopXXPage(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                                                  @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                                  @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current,size);
        return ResponseHelper.buildResponse(statisticsService.inspectionTimelinessTopXXPage(page,dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名下钻类型", notes = "大屏-应急-维保单位平均救援时间排名下钻类型")
    @PostMapping(value = "/timeliness/topType")
    public ResponseModel<List<Map<String, Object>>> inspectionTimelinessTopXXType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectionTimelinessTopXXType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-检验检测机构公示", notes = "大屏-检验检测-检验检测机构公示")
    @PostMapping(value = "/inspectionOrgList/publicity")
    public ResponseModel<List<PublicityInspectOrgInfoDto>> inspectionOrgListForPublicity(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionOrgListForPublicity(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备报检/待检数量统计", notes = "大屏-检验检测-八大类设备报检/待检数量统计")
    @PostMapping(value = "/inspectionEquip/countByEquList")
    public ResponseModel<Map<String, Object>> inspectionEquipCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryInspectionEquipByEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-中间地图左侧全局统计", notes = "大屏-检验检测-中间地图左侧全局统计")
    @PostMapping(value = "/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-中间地图地市统计", notes = "大屏-检验检测-中间-地图地市统计")
    @PostMapping(value = "/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备检验临期、超期统计", notes = "大屏-检验检测-八大类设备检验临期、超期统计")
    @PostMapping(value = "/equipInspectTime/countByEquList")
    public ResponseModel<Map<String, Object>> equipInspectTimeCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equipInspectTimeCountByEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备检验临期、超期统计下钻上部图例", notes = "大屏-检验检测-八大类设备检验临期、超期统计下钻上部图例")
    @PostMapping(value = "/equipInspectTime/equipInspectTimeCountListDetail")
    public ResponseModel<Map<String, Object>> equipInspectTimeCountListDetail(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equipInspectTimeCountListDetail(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备检验临期、超期统计下钻下部列表", notes = "大屏-检验检测-八大类设备检验临期、超期统计下钻下部列表")
    @PostMapping(value = "/equipInspectTime/equipInspectTimeCountListDetailList")
    public ResponseModel<Page<JSONObject>> equipInspectTimeCountListDetailList(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result,
                                                                               @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                               @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        dpFilterParamDto.setCurrent(current);
        dpFilterParamDto.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.equipInspectTimeCountListDetailList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-检验检测-八大类设备检验临期、超期统计下钻筛选条件", notes = "大屏-检验检测-八大类设备检验临期、超期统计下钻筛选条件")
    @PostMapping(value = "/equipInspectTime/equipInspectTimeCountListDetailSearch")
    public ResponseModel<List<Map<String,Object>>> equipInspectTimeCountListDetailSearch(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equipInspectTimeCountListDetailSearch(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/pageList")
    @ApiOperation(httpMethod = "POST", value = "检验检测报检申请列表分页,按照区域过滤", notes = "检验检测报检申请列表分页,按照区域过滤")
    public ResponseModel<Page<JyjcInspectionApplicationDto>> queryForPageList(@RequestParam(value = "current") int current,
                                                                                @RequestParam(value = "size") int size,
                                                                                @RequestBody JyjcInspectionApplicationDto model) {
        if(StringUtils.isEmpty(model.getCityCode())){
            model.setCityCode("610000");
        }
        Page<JyjcInspectionApplicationDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.queryForInspectAppPageList(page, model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/matui/{sequenceNbr}")
    @ApiOperation(httpMethod = "POST", value = "检验检测报检申请详情资源附件", notes = "检验检测报检申请详情资源附件")
    public ResponseModel<JSONObject> queryDetailsMatui(@PathVariable Long sequenceNbr, @RequestBody JSONObject jsonObject) {
        return ResponseHelper.buildResponse(statisticsService.queryDetailsMatui(sequenceNbr, JSONObject.parseObject(JSON.toJSONString(jsonObject))));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/handle/status")
    @ApiOperation(httpMethod = "GET", value = "检验检测办理状态", notes = "检验检测办理状态")
    public ResponseModel<List<Map<String,Object>>> handleStatus() {
        return ResponseHelper.buildResponse(statisticsService.handleStatus());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/getBusinessType")
    @ApiOperation(httpMethod = "POST", value = "大屏检验检测下钻获取检验类型", notes = "大屏检验检测下钻获取检验类型")
    public ResponseModel<List<Map<String, Object>>> getBusinessType(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(statisticsService.getBusinessType(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/getInspectDetail")
    @ApiOperation(httpMethod = "POST", value = "大屏检验检测下钻获取上部图表", notes = "大屏检验检测下钻获取上部图表")
    public ResponseModel<Map<String, Object>> getInspectDetail(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(statisticsService.getInspectDetail(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/getInspectDetailList")
    @ApiOperation(httpMethod = "POST", value = "大屏检验检测下钻获取下部列表", notes = "大屏检验检测下钻获取下部列表")
    public ResponseModel<Page<Map<String, Object>>> getInspectDetailList(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto,
                                                                         @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                         @RequestParam(value = "size", defaultValue = "20") Integer size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(statisticsService.getInspectDetailList(dpFilterParamForDetailDto, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/inspectApplication/getInspectBusinessList")
    @ApiOperation(httpMethod = "POST", value = "大屏检验检测业务管理下钻获取下部列表", notes = "大屏检验检测业务管理下钻获取下部列表")
    public ResponseModel<Page<Map<String, Object>>> getInspectBusinessList(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto,
                                                                         @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                         @RequestParam(value = "size", defaultValue = "20") Integer size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(statisticsService.getInspectBusinessList(dpFilterParamForDetailDto, page));
    }
}



