package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotation.FileCheck;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.enums.FileType;
import com.yeejoin.amos.boot.module.ys.api.dto.YsEmergencyUnitDto;
import com.yeejoin.amos.boot.module.ys.api.entity.YsEmergencyUnit;
import com.yeejoin.amos.boot.module.ys.api.service.IYsEmergencyUnitService;
import com.yeejoin.amos.boot.module.ys.biz.service.impl.YsEmergencyUnitServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author system_generator
 * @date 2024-09-24
 */
@RestController
@Api(tags = "应急联动单位管理")
@RequestMapping(value = "/ys-emergency-unit")
public class YsEmergencyUnitController extends BaseController {

    @Autowired
    YsEmergencyUnitServiceImpl ysEmergencyUnitServiceImpl;
	@Autowired
	IYsEmergencyUnitService iYsEmergencyUnitService;


	/**
	 * 新增或更新
	 * @param ysEmergencyUnitDto
	 * @return
	 * @author chang xiangyu
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	    @PostMapping(value = "/saveOrUpdate")
	    @ApiOperation(httpMethod = "POST", value = "新增或者更新", notes = "新增或者更新")
	    public ResponseModel<Boolean> saveOrUpdate(@RequestBody YsEmergencyUnitDto ysEmergencyUnitDto) {
	        AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
	        return ResponseHelper.buildResponse(iYsEmergencyUnitService.saveOrUpdate(ysEmergencyUnitDto, userModel));
	    }
	/**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<YsEmergencyUnitDto> save(@RequestBody YsEmergencyUnitDto model) {
	    model = ysEmergencyUnitServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<YsEmergencyUnitDto> updateBySequenceNbrYsEmergencyUnit(@RequestBody YsEmergencyUnitDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(ysEmergencyUnitServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(ysEmergencyUnitServiceImpl.removeById(sequenceNbr));
    }

	/**
	 * 根据sequenceNbr删除
	 * @param sequenceNbr 主键
	 * @return
	 * @author chang xiangyu
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/deleteBySeq")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
	public ResponseModel<Boolean> deleteBySeq(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
		return ResponseHelper.buildResponse(iYsEmergencyUnitService.deleteBySeq(sequenceNbr));
	}

//    /**
//     * 根据sequenceNbr查询
//     *
//	 * @param sequenceNbr  主键
//     * @return
//     */
//	@TycloudOperation(ApiLevel = UserType.AGENCY)
//	@GetMapping(value = "/{sequenceNbr}")
//	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
//	public ResponseModel<YsEmergencyUnitDto> selectOne(@PathVariable Long sequenceNbr) {
//	    return ResponseHelper.buildResponse(iYsEmergencyUnitService.queryBySeq(sequenceNbr));
//	}

	/**
	 * @author chang xiangyu
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getDetail")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<YsEmergencyUnitDto> selectOne( Long sequenceNbr) {
		return ResponseHelper.buildResponse(iYsEmergencyUnitService.querySafeUnitBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     * @author chang xiangyu
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<YsEmergencyUnitDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,YsEmergencyUnitDto ysEmergencyUnitDto) {
	    Page<YsEmergencyUnit> page = new Page<YsEmergencyUnit>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(iYsEmergencyUnitService.querySafeUnitsByPage(page,ysEmergencyUnitDto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<YsEmergencyUnitDto>> selectForList() {
	    return ResponseHelper.buildResponse(ysEmergencyUnitServiceImpl.queryForYsEmergencyUnitList());
	}


	/**
	 * 单表导出excel
	 * @param response
	 * @param ids
	 *
	 * @author chang xiangyua
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "联动单元列表数据导出", notes = "联动单元列表数据导出")
	public void expertDataExport(HttpServletResponse response, String ids) {
		Assert.hasText(ids,"未选择导出数据");
		iYsEmergencyUnitService.export(response, Arrays.asList(ids.split(",")));
	}

	/**
	 * @author chang xiangyu
	 * @param file
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/import")
	@ApiOperation(httpMethod = "POST", value = "联动单元列表数据导入", notes = "联动单元列表数据导入")
	public ResponseModel<Object> expertDataImport(@RequestBody MultipartFile file) {
		// 校验文件是否为空
		if (file.isEmpty()) {
			return ResponseHelper.buildResponse("文件不能为空");
		}
		// 校验文件类型为 Excel
		String contentType = file.getContentType();
		String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());
		// 校验 Excel 文件的 MIME type 和扩展名
		if (!("application/vnd.ms-excel".equals(contentType) ||
				"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
				!("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
			return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
		}
		AgencyUserModel userModel = getSelectedOrgInfo().getUserModel();
		return iYsEmergencyUnitService.expertDataImport(file,userModel);
	}


}
