package com.yeejoin.amos;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;

/**
 * <pre>
 * 机场服务启动类
 * </pre>
 *
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
		"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
		"com.yeejoin.amos.boot.module.*.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan(basePackages = { "org.typroject", "com.yeejoin.amos" })
public class AmosJcsApplication {
	private static final Logger logger = LoggerFactory.getLogger(AmosJcsApplication.class);

	public static void main(String[] args) throws UnknownHostException {
		ConfigurableApplicationContext context = SpringApplication.run(AmosJcsApplication.class, args);
		Environment env = context.getEnvironment();
		delKey(env, context);// 添加全部清空redis缓存的方法 2021-09-09
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
		GlobalExceptionHandler.setAlwaysOk(true);
        String logs=String.format("%n----------------------------------------------------------%n Application Amos-Biz-Boot is running! Access URLs:%n Swagger文档: http:// %c : %c  %c /doc.html%n----------------------------------------------------------",ip,port,path);
		logger.info( logs);
	}

	/**
	 * 清空redis缓存数据
	 * 
	 * @author 陈浩
	 * @param env
	 * @param context
	 */
	public static void delKey(Environment env, ConfigurableApplicationContext context) {
		if (Boolean.parseBoolean(env.getProperty("my.spring.redis.cache.isclean"))) {
			@SuppressWarnings("rawtypes")
			RedisTemplate redisTemplate = context.getBean("redisTemplate", RedisTemplate.class);
			RedisConnection redisConnection = null;
			try {
				RedisConnectionFactory redisConnectionFactory=redisTemplate.getConnectionFactory();
				if(redisConnectionFactory!=null){
					redisConnection = redisConnectionFactory.getConnection();
					redisConnection.flushAll();
				}
			} catch (Exception e) {
				logger.info("删除redis 缓存的key 失败");
			} finally {
				if(redisConnection!=null){
					redisConnection.close();
				}

			}
		}

	}

}
