package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 重点部位
 *
 * @author system_generator
 * @date 2021-07-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="KeySiteDto", description="重点部位")
public class KeySiteDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "重点部位名称")
    private String name;

    @ApiModelProperty(value = "所属单位/部门id")
    private Long belongId;

    @ApiModelProperty(value = "所属建筑id")
    private Long buildingId;

    @ApiModelProperty(value = "位置描述")
    private String addressDesc;

    @ApiModelProperty(value = "建筑面积(㎡)")
    private String buildingArea;

    @ApiModelProperty(value = "建筑高度(m)")
    private String buildingHeight;

    @ApiModelProperty(value = "耐火等级")
    private String fireEnduranceRate;

    @ApiModelProperty(value = "使用性质")
    private String useNature;

    @ApiModelProperty(value = "责任人")
    private String chargePerson;

    @ApiModelProperty(value = "责任人身份证")
    private String chargePersonId;

    @ApiModelProperty(value = "确定重点防火部位的原因")
    private String keyPreventionReason;

    @ApiModelProperty(value = "消防设施情况")
    private String fireFacilitiesInfo;

    @ApiModelProperty(value = "防火标志设立情况")
    private String firePreventionFlag;

    @ApiModelProperty(value = "危险源")
    private String hazard;

    @ApiModelProperty(value = "消防安全管理措施")
    private String safetyManagementMeasures;

    @ApiModelProperty(value = "防范手段措施")
    private String preventiveMeasures;

    @ApiModelProperty(value = "备注")
    private String remark;

}
