package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 重点部位
 *
 * @author system_generator
 * @date 2021-07-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_key_site")
public class KeySite extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 重点部位名称
     */
	@TableField("name")
    private String name;

    /**
     * 所属单位/部门id
     */
	@TableField("belong_id")
    private Long belongId;

    /**
     * 所属建筑id
     */
	@TableField("building_id")
    private Long buildingId;

    /**
     * 位置描述
     */
	@TableField("address_desc")
    private String addressDesc;

    /**
     * 建筑面积(㎡)
     */
	@TableField("building_area")
    private String buildingArea;

    /**
     * 建筑高度(m)
     */
	@TableField("building_height")
    private String buildingHeight;

    /**
     * 耐火等级
     */
	@TableField("fire_endurance_rate")
    private String fireEnduranceRate;

    /**
     * 使用性质
     */
	@TableField("use_nature")
    private String useNature;

    /**
     * 责任人
     */
	@TableField("charge_person")
    private String chargePerson;

    /**
     * 责任人身份证
     */
	@TableField("charge_person_id")
    private String chargePersonId;

    /**
     * 确定重点防火部位的原因
     */
	@TableField("key_prevention_reason")
    private String keyPreventionReason;

    /**
     * 消防设施情况
     */
	@TableField("fire_facilities_info")
    private String fireFacilitiesInfo;

    /**
     * 防火标志设立情况
     */
	@TableField("fire_prevention_flag")
    private String firePreventionFlag;

    /**
     * 危险源
     */
	@TableField("hazard")
    private String hazard;

    /**
     * 消防安全管理措施
     */
	@TableField("safety_management_measures")
    private String safetyManagementMeasures;

    /**
     * 防范手段措施
     */
	@TableField("preventive_measures")
    private String preventiveMeasures;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

}
