package com.yeejoin.amos.boot.module.common.api.entity;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModelProperty;


/**
* 维保单位
*
* @author system_generator
* @date 2021-07-16
*/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName(value = "cb_maintenance_company")
public class MaintenanceCompany extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 企业名称
     */
	@TableField("name")
    private String name;

    /**
     * 单位编码
     */
	@TableField("code")
    private String code;
    
    /**
     * 类型（COMPANY单位，PERSON人员,DEPARTMENT部门）
     */
	@TableField("type")
    private String type;

    /**
     * 上级单位
     */
	@TableField("parent_id")
    private Long parentId;

    /**
     * 业务编码
     */
	@TableField("biz_code")
    private String bizCode;

    /**
     * 组织机构代码用于权限过滤
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 纬度
     */
	@TableField("latitude")
    private String latitude;

    /**
     * 经度
     */
	@TableField("longitude")
    private String longitude;

    /**
     * 动态表单实例id
     */
	@TableField("instance_id")
    private Long instanceId;
	
	@ApiModelProperty(value = "动态表单值")
	@TableField(exist = false)
	private List<DynamicFormInstance> dynamicFormValue;

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private Map<String, List<AttachmentDto>> attachments;
}
