package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceTypeDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceZhDto;
import com.yeejoin.amos.boot.module.common.api.entity.WaterResource;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2021-06-29
 */
public interface WaterResourceMapper extends BaseMapper<WaterResource> {

    List<WaterResourceDto> exportToExcel(Boolean isDelete);


    /***
     *
     *  指挥水源资源 列表
     *
     * **/
    List<WaterResourceZhDto> getWaterResourceList(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

    /***
     *
     *  指挥水源资源统计
     *
     * **/
    Integer getWaterResourceListCount(@Param("par")RequestData par);


    List<WaterResourceTypeDto> getWaterResourceTypeList(Boolean isDelete);
}
