package com.yeejoin.amos.boot.module.command.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.command.api.dao.SeismometeorologyDtoDao;
import com.yeejoin.amos.boot.module.command.api.dto.SeismometeorologyDto;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.common.api.service.*;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledZhDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.InstructionsZHDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.StateDot;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertStageEnums;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedService;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerTransferService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.DateUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * *指挥资源Api
 *
 * <PRE>
 * author tw
 * date 2021/7/15
 * </PRE>
 */
@RestController
@Api(tags = "指挥资源Api")
@RequestMapping(value = "/command")
public class CommandController extends BaseController {

    @Autowired
    IAlertCalledService iAlertCalledService;
    @Autowired
    IFireStationService iFireStationService;
    @Autowired
    IFireTeamService iFireTeamService;
    @Autowired
    IWaterResourceService iWaterResourceService;
    @Autowired
    SeismometeorologyDtoDao seismometeorologyDtoDao;
    @Autowired
    IOrgUsrService  iOrgUsrService;
    @Autowired
    ILinkageUnitService  iLinkageUnitService;
    @Autowired
    IAlertSubmittedService alertSubmittedService;
    @Autowired
    IDataDictionaryService  dataDictionaryService;
    @Autowired
    IFireChemicalService fireChemicalService;

    @Autowired
    IFireExpertsService fireExpertsService;
    
    @Autowired
    IFirefightersService firefightersService;


    @Autowired
    IPowerTransferService powerTransferService;
    /**
     * 警情列表
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "JQ/list")
    @ApiOperation(httpMethod = "GET", value = "警情列表查询", notes = "警情列表查询")
    public ResponseModel<Object> listPage(RequestData par) {
        List<AlertCalledZhDto> list= iAlertCalledService.alertCalledListByAlertStatus(par);
        return ResponseHelper.buildResponse(list);
    }


    /**
     * 保卫目标分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "ZDDW/list")
    @ApiOperation(httpMethod = "GET", value = "保卫目标列表分页查询", notes = "保卫目标列表分页查询")
    public ResponseModel<IPage<CompanyDto>> listPageZDDW(Integer pageNum, Integer pageSize, RequestData par) {
        Page<CompanyDto> pageBean = new Page<>(pageNum, pageSize);
        List<CompanyDto>  list= iOrgUsrService.listContractDto(pageNum,pageSize,par);
        Integer num=  iOrgUsrService.listContractDtoCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

   /**
    * * @param null
    * @return
    * <PRE>
    * author tw
    * date 2021/7/21
    * </PRE>
    * 保卫目标详情
    */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "ZDDW/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "保卫目标详情", notes = "保卫目标详情")
    public ResponseModel<OrgUsrFormDto> selectZDDWById(@PathVariable Long id) throws Exception {

        return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyById(id));
    }




    /**
     * 微型消防站列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "WX/list")
    @ApiOperation(httpMethod = "GET", value = "微型消防站列表分页查询", notes = "微型消防站列表分页查询")
    public ResponseModel<IPage<FireStationzhDto>> listPageWx(Integer pageNum, Integer pageSize, RequestData par) {
        Page<FireStationzhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireStationzhDto>  list= iFireStationService.getStationList(pageNum,pageSize,par);
        Integer num=  iFireStationService.getStationListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }
    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "SY500/list")
    @ApiOperation(httpMethod = "GET", value = "500水源列表分页查询", notes = "500水源列表分页查询")
    public ResponseModel<IPage<WaterResourceZhDto>> listPageSY500(Integer pageNum, Integer pageSize, RequestData par) {

        par.setDistance(500D);

        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }



    /**
     * 水源列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "SY1000/list")
    @ApiOperation(httpMethod = "GET", value = "1000水源列表分页查询", notes = "1000水源列表分页查询")
    public ResponseModel<IPage<WaterResourceZhDto>> listPageSY1000(Integer pageNum, Integer pageSize, RequestData par) {
        par.setDistance(1000D);
        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }



//    /**
//     * 水源列表分页查询
//     *
//     * @return
//     */
//    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
//    @GetMapping(value = "SYTY/list")
//    @ApiOperation(httpMethod = "GET", value = "水源列表分页查询", notes = "水源列表分页查询")
//    public ResponseModel<IPage<WaterResourceZhDto>> listPageSYTY(Integer pageNum, Integer pageSize, RequestData par) {
//        Page<WaterResourceZhDto> pageBean = new Page<>(pageNum, pageSize);
//        List<WaterResourceZhDto>  list= iWaterResourceService.getWaterResourceList(pageNum,pageSize,par);
//        Integer num=  iWaterResourceService.getWaterResourceListCount(par);
//        pageBean.setRecords(list);
//        pageBean.setTotal(num);
//        return ResponseHelper.buildResponse(pageBean);
//    }


    /**
     * 消防队伍列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "DW/list")
    @ApiOperation(httpMethod = "GET", value = "消防队伍列表分页查询", notes = "消防队伍列表分页查询")
    public ResponseModel<IPage<FireTeamZhDto>> listPage(Integer pageNum, Integer pageSize, RequestData par) {
        par.setTypeCode(AlertStageEnums.YWDD.getCode());
        Page<FireTeamZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireTeamZhDto>  list= iFireTeamService.getFireTeamList(pageNum,pageSize,par);
        Integer num=  iFireTeamService.getFireTeamListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

    /**
     * 联动力量列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "linkageForce/list")
    @ApiOperation(httpMethod = "GET", value = "联动力量列表分页查询", notes = "联动力量列表分页查询")
    public ResponseModel<IPage<LinkageUnitZhDto>> linkageForcelistPage(Integer pageNum, Integer pageSize, RequestData par) {
        Page<LinkageUnitZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<LinkageUnitZhDto>  list= iLinkageUnitService.listLinkageUnitZhDto(pageNum,pageSize,par);
        Integer num=  iLinkageUnitService.listLinkageUnitZhDtoCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/21
     * </PRE>
     * 联动单位详情
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "linkageForce/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个联动单位", notes = "根据sequenceNbr查询单个联动单位")
    public ResponseModel<LinkageUnitDto> selectlinkageForceOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(iLinkageUnitService.queryOne(sequenceNbr));
    }


    /**
     * 消防队伍列表分页查询
     *
     * @return
     */
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "ZQ/list")
    @ApiOperation(httpMethod = "GET", value = "执勤实力列表分页查询", notes = "执勤实力列表分页查询")
    public ResponseModel<IPage<FireTeamZhDto>> ZQlistPage(Integer pageNum, Integer pageSize, RequestData par) {
        if(par.getTypeCode()==null){
            par.setTypeCode( AlertStageEnums.ZZZD.getCode()+","+AlertStageEnums.YLJY.getCode());
        }
        Page<FireTeamZhDto> pageBean = new Page<>(pageNum, pageSize);
        List<FireTeamZhDto>  list= iFireTeamService.getFireTeamList(pageNum,pageSize,par);
        Integer num=  iFireTeamService.getFireTeamListCount(par);
        pageBean.setRecords(list);
        pageBean.setTotal(num);
        return ResponseHelper.buildResponse(pageBean);
    }
    /**
     *
     * 根据id查询警情详情
     *
     * **/

    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "JQ/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id查询灾情详情", notes = "根据id查询灾情详情")
    public ResponseModel<Object> selectById(@PathVariable Long id) {

        return ResponseHelper.buildResponse(iAlertCalledService.selectAlertCalledKeyValueLabelById(id));

    }



    /**
     * 根据id查询微型消防站
     *
     * @param id 主键
     *
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "WX/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id查询微型消防站", notes = "根据id查询微型消防站")
    public ResponseModel<FireStationDto> seleteOne(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iFireStationService.selectBySequenceNbr(id));
    }




    /**
     * 根据id查询水源
     *
     * @param id 主键
     *
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "SY/{id}")
    @ApiOperation(httpMethod = "GET", value = "根据id查询水源", notes = "根据id查询水源")
    public ResponseModel<WaterResourceDto> selectOne(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iWaterResourceService.selectBySequenceNbr(id));
    }


    /**
     * 根据id查询队伍信息
     *
     * @param id
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "DW/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询队伍信息", notes = "根据id查询队伍信息")
    public ResponseModel<FireTeam> selectById(HttpServletRequest request, @PathVariable Long id) {
        return ResponseHelper.buildResponse(iFireTeamService.getFireTeamBySequenceNbr(id));
    }


    /**
     * 跑马灯
     *
     * @param
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/seismometeorology", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "跑马灯", notes = "跑马灯")
    public ResponseModel<Object> seismometeorology()throws Exception {
        RequestData requestData = new RequestData();
        requestData.setWhether24(true);
        List<AlertCalledZhDto> list= iAlertCalledService.alertCalledListByAlertStatus(requestData);
        List<SeismometeorologyDto> li= seismometeorologyDtoDao.findCarStateByWatchSn();
        //数据组装
        for (AlertCalledZhDto alertCalledZhDto : list) {

            StringBuffer st=new StringBuffer();

            String time= DateUtil.formatDate(alertCalledZhDto.getCallTime(),"yyyy-MM-dd HH:mm:ss");

            st.append("【").append(alertCalledZhDto.getAlertType()).append("】").append(" ").append(time).append(" ").append(alertCalledZhDto.getAddress());

            SeismometeorologyDto sto= new SeismometeorologyDto(alertCalledZhDto.getSequenceNbr(), "1", "警情通知", null,alertCalledZhDto.getCallTime().getTime(), null, st.toString()) ;
            li.add(sto);
            }
       return ResponseHelper.buildResponse(li);
    }



    /**
     * 根据id指令
     *
     * @param id
     * @return
     */
    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "ZL/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据警情id查询指令信息", notes = "根据警情id查询指令信息")
    public ResponseModel<List<InstructionsZHDto>> selectZL(@PathVariable Long id) {
        return ResponseHelper.buildResponse(alertSubmittedService.getInstructionsZHDtoList(id));
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/gwmcDataDictionary/FireChemical/{type}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据字典类型查询危险品字典", notes = "根据字典类型查询危险品字典")
    public ResponseModel<Object> gwmcDataDictionaryFireChemical(@PathVariable String type) throws Exception {
       Object list = dataDictionaryService.getFireChemical(type);
         return ResponseHelper.buildResponse(list);
     }

    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "危化品分页查询", notes = "危化品分页查询")
    public ResponseModel<Page<FireChemicalDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum,
                                                             @RequestParam(value = "pageSize") int pageSize, String casNo,
                                                             String formula, String name, String typeCode) {
        Page<FireChemicalDto> page = new Page<FireChemicalDto>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
        boolean isDelete = false;
        return ResponseHelper.buildResponse(fireChemicalService.queryForFireChemicalPage(page, casNo, formula,
                name, typeCode, isDelete));
    }


    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/gwmcDataDictionary/{type}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据字典类型查询字典", notes = "根据字典类型查询字典")
    public ResponseModel<Object> gwmcDataDictionary(@PathVariable String type) throws Exception {

        Object list = dataDictionaryService.gwmcDataDictionary(type);
        return ResponseHelper.buildResponse(list);

    }

    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "fireExperts/page")
    @ApiOperation(httpMethod = "GET", value = "外部专家分页查询", notes = "外部专家分页查询")
    public ResponseModel<IPage<FireExpertsDto>> queryForPage(@RequestParam(value = "pageNum") int pageNum,
                                                             @RequestParam(value = "pageSize") int pageSize,
                                                             FireExpertsDto fireExpertsDto) {
        Page<FireExpertsDto> page = new Page<>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
         Page<FireExpertsDto> fireExpertsDtoPage = fireExpertsService.queryForFireExpertsPage(page, false,
                fireExpertsDto.getName(), fireExpertsDto.getExpertCode());
        return ResponseHelper.buildResponse(fireExpertsDtoPage);
    }


    @TycloudOperation( needAuth = true,ApiLevel = UserType.AGENCY)
    @GetMapping(value = "LinkageUnitDto/page")
    @ApiOperation(httpMethod = "GET", value = "联动单位分页查询", notes = "联动单位分页查询")
    public ResponseModel<Page<LinkageUnitDto>> LinkageUnitDtoqueryForPage(@RequestParam(value = "pageNum") int pageNum,
                                                            @RequestParam(value = "pageSize") int pageSize,
                                                            String unitName, String linkageUnitType, String inAgreement) {
        Page<LinkageUnitDto> page = new Page<LinkageUnitDto>();
        page.setCurrent(pageNum);
        page.setSize(pageSize);
        Page<LinkageUnitDto> linkageUnitDtoPage = iLinkageUnitService.queryForLinkageUnitPage(page, false,
                unitName, linkageUnitType);

        return ResponseHelper.buildResponse(linkageUnitDtoPage);
    }

    
    
    @TycloudOperation( needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getFirefighters", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "内部专家列表分页查询", notes = "内部专家列表分页查询")
    public ResponseModel<Page<FirefightersZhDto>> getFirefighters(Integer pageNum, Integer pageSize,
                                                             FirefightersDto firefighters) {   	
    	if(firefighters.getAreasExpertiseCode()==null) {
    		firefighters.setAreasExpertiseCode("0");
    	}  	
        //条件分页
        if (null == pageNum || null == pageSize) {
            pageNum = 1;
            pageSize = Integer.MAX_VALUE;
        }
        List<FirefightersZhDto> list = firefightersService.getFirefighters((pageNum - 1) * pageSize, pageSize,
                firefighters);
        Map<String, Long> num = firefightersService.getFirefightersCount((pageNum - 1) * pageSize, pageSize,
                firefighters);
        Page<FirefightersZhDto> pageBean = new Page<>(pageNum, pageSize, num.get("num"));
        pageBean.setRecords(list);
        return ResponseHelper.buildResponse(pageBean);
    }
    
    
    /**
    *
    * 火灾现场统计
    *
    * **/

   @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
   @GetMapping(value = "statistics/{id}")
   @ApiOperation(httpMethod = "GET", value = "火灾现场统计", notes = "火灾现场统计")
   public ResponseModel<Object> getStatistics(@PathVariable Long id) {

       return ResponseHelper.buildResponse(iAlertCalledService.selectAlertCalledcount(id));

   }
    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量统计
     */
    @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getpower/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量统计", notes = "到场力量统计")
    public ResponseModel<Object> getpower(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iAlertCalledService.powercount(id));
    }
   
    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量统计列表
     */
    @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getPowerDataList/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量统计列表", notes = "到场力量统计列表")
    public ResponseModel<Object> getPowerDataList(@PathVariable Long id) {
        return ResponseHelper.buildResponse(iAlertCalledService.getPowerDataList(id));
    }

    /**
     *
     * 力量统计当前灾情阶段
     *
     * */
    @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getstate/{id}")
    @ApiOperation(httpMethod = "GET", value = "获取灾情当前阶段", notes = "获取灾情当前阶段")
    public ResponseModel<Object> getstate(@PathVariable Long id) {
        AlertCalled AlertCalled=iAlertCalledService.getAlertCalledById(id);

        List<StateDot> list=new ArrayList<>();
        list.add(new StateDot("警情接报"));
        list.add(new StateDot("力量调派"));
        list.add(new StateDot("值班确警"));
        list.add(new StateDot("处置跟踪"));
        list.add(new StateDot("处置结束"));
        list.stream().forEach(stateDot->{
            if(AlertCalled.getAlertStage().equals(stateDot.getName())){
                stateDot.setFlag(true);
            }
        });
        return ResponseHelper.buildResponse(list);
    }

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/22
     * </PRE>
     * 到场力量 列表统计
     */
    @TycloudOperation( needAuth = false, ApiLevel = UserType.AGENCY)
    @GetMapping(value = "getPowerCompanyCountDtocount/{id}")
    @ApiOperation(httpMethod = "GET", value = "到场力量 列表统计", notes = "到场力量 列表统计")
    public ResponseModel<Object> getPowerCompanyCountDtocount(@PathVariable Long id) {
        return ResponseHelper.buildResponse(powerTransferService.getPowerCompanyCountDtocount(id));
    }

}