package com.yeejoin.amos.fas.business.controller;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.fas.business.param.FireEquipmentParam;
import com.yeejoin.amos.fas.business.param.FireEquipmentPointParam;
import com.yeejoin.amos.fas.business.param.WaterResourceParam;
import com.yeejoin.amos.fas.business.service.intfc.IExcelService;
import com.yeejoin.amos.fas.business.util.FileHelper;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.exception.YeeException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/excel")
@Api(tags = "导入导出excel")
public class ExcelController extends AbstractBaseController {

    private final Logger logger = LoggerFactory.getLogger(ExcelController.class);

    @Autowired
    private IExcelService iExcelService;

    @Permission
    @ApiOperation(value = "导入消防装备数据", notes = "导入消防装备数据")
    @PostMapping(value = "/import/fireEquipment")
    public CommonResponse importFireEquipment(@RequestPart("file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            try {
                List<FireEquipmentParam> list = FileHelper.importExcel(file, 1, 1, FireEquipmentParam.class);
                iExcelService.importFireEquipment(list);
                return CommonResponseUtil.success();
            } catch (Exception e) {
                logger.info("导入消防装备数据异常", e);
                return CommonResponseUtil.failure("导入失败");
            }
        } else {
            return CommonResponseUtil.failure("文件格式错误");
        }
    }

    @Permission
    @ApiOperation(value = "导入装备监测点数据", notes = "导入装备监测点数据")
    @PostMapping(value = "/import/fireEquipmentPoint")
    public CommonResponse importFireEquipmentPoint(@RequestPart("file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            try {
                List<FireEquipmentPointParam> list = FileHelper.importExcel(file, 1, 1, FireEquipmentPointParam.class);
                ReginParams reginParams =getSelectedOrgInfo();
        		String orgCode=getOrgCode(reginParams);
                iExcelService.importFireEquipmentPoint(list, orgCode,getUserId());
                return CommonResponseUtil.success();
            } catch (Exception e) {
                logger.info("导入装备监测点数据", e);
                return CommonResponseUtil.failure("导入失败");
            }
        } else {
            return CommonResponseUtil.failure("文件格式错误");
        }
    }

    @Permission
    @ApiOperation(value = "导出数据", notes = "导出数据")
    @PostMapping(value = "/export")
    //@Authorization(ingore = true)
    public void export(HttpServletResponse response,
                       @ApiParam(value = "data：导出数据；model：导出模板", required = true) @RequestParam String exportType,
                       @ApiParam(value = "point：监测点；equipment：设备", required = true) @RequestParam String modelName,
                       @ApiParam(value = "查询条件") @RequestBody(required = false) Map<String, Object> paramsMap) {
    	
    	ReginParams reginParams =getSelectedOrgInfo();
    	String orgCode = getOrgCode(reginParams);
    	paramsMap.put("compCode", orgCode);
    	
        String fileName = UUID.randomUUID().toString() + ".xls";
        String title = "监测点";
        Class cls = null;
        if ("point".equals(modelName)) {
            title = "消防点位";
            cls = FireEquipmentPointParam.class;
        } else if ("equipment".equals(modelName)) {
            title = "消防资源";
            cls = FireEquipmentParam.class;
        } else if ("water".equals(modelName)) {
            title = "水资源";
            cls = WaterResourceParam.class;
        }
        if (cls != null) {
            List<?> list = Lists.newArrayList();
            if ("data".equals(exportType)) {
                list = iExcelService.exportPointData(paramsMap);
            }
            FileHelper.exportExcel(list, title, title, cls, fileName, response);
        }
    }

    @Permission
    @ApiOperation(value = "导入数据", notes = "导入数据")
    @PostMapping(value = "/import/data/excel/{type}")
    public CommonResponse importExcelData(@RequestPart("file") MultipartFile file, @ApiParam(value = "导入资源类型", required = true) @PathVariable String type) {
        String fileName = file.getOriginalFilename();
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            try {
                if ("fireResource".equals(type)) {//导入消防装备
                    List<FireEquipmentParam> list = FileHelper.importExcel(file, 1, 1, FireEquipmentParam.class);
                    iExcelService.importFireEquipment(list);
                }
//                else if ("water".equals(type)) {//导入水资源
//                    List<WaterResourceParam> list = FileHelper.importExcel(file, 1, 1, WaterResourceParam.class);
//                    iExcelService.importWaterResource(list);
//                }
                return CommonResponseUtil.success();
            } catch (YeeException e) {
            	logger.info("导入数据异常", e);
                return CommonResponseUtil.failure(e.getMessage());
			} catch (Exception e) {
                logger.info("导入数据异常", e);
                return CommonResponseUtil.failure("导入失败");
            }
        } else {
            return CommonResponseUtil.failure("文件格式错误");
        }
    }
}
