package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.jcs.api.dto.*;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferCompanyMapper;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.EnumsUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dto.FormValue;
import com.yeejoin.amos.boot.module.common.api.entity.DataDictionary;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmitted;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmittedObject;
import com.yeejoin.amos.boot.module.jcs.api.entity.Template;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertBusinessTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSchedulingTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSubmitTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.FireCarStatusEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.SubmissionMethodEnum;
import com.yeejoin.amos.boot.module.jcs.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertSubmittedMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedObjectService;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedService;
import com.yeejoin.amos.boot.module.jcs.biz.rule.action.AlertCalledAction;
import com.yeejoin.amos.component.rule.config.RuleConfig;

/**
 * 警情报送记录 服务实现类
 *
 * @author tb
 * @date 2021-06-17
 */
@Service
public class AlertSubmittedServiceImpl extends BaseService<AlertSubmittedDto, AlertSubmitted, AlertSubmittedMapper> implements IAlertSubmittedService {

    @Autowired
    IAlertSubmittedObjectService iAlertSubmittedObjectService;
    @Autowired
    AlertSubmittedObjectServiceImpl alertSubmittedObjectServiceImpl;
    @Autowired
    AlertCalledServiceImpl alertCalledService;
    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;
    @Autowired
    TemplateServiceImpl templateService;
    @Autowired
    PowerTransferServiceImpl powerTransferService;
    @Autowired
    RuleAlertCalledService ruleAlertCalledService;
    @Autowired
    AlertCalledAction alertCalledAction;
    @Autowired
    OrgUsrServiceImpl orgUsrService;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private EmqKeeper emqKeeper;

    @Value("${mqtt.topic.alert.reporting}")
    private String topic;

    @Autowired
    EquipFeignClient equipFeignClient;

    @Autowired
    AlertSubmittedMapper alertSubmittedMapper;
    @Autowired
    PowerTransferCompanyMapper powerTransferCompanyMapper;

    @Override
    public SchedulingReportingDto listSchedulingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingDto schedulingReportingDto = new SchedulingReportingDto();
        List<AlertSubmittedExtDto> alertSubmittedExtDtoList = this.baseMapper.listSchedulingByParam(queryParam);
        schedulingReportingDto.setSchedulingReportingList(alertSubmittedExtDtoList);
        Map<String, List<AlertSubmittedExtDto>> groupMap =
                alertSubmittedExtDtoList.stream().collect(Collectors.groupingBy(AlertSubmittedExtDto::getSubmissionMethodCode));
        int phoneSize = 0;
        int smsSize = 0;
        if (ObjectUtils.isNotEmpty(groupMap.get(SubmissionMethodEnum.PHONE.getCode()))) {
            phoneSize = groupMap.get(SubmissionMethodEnum.PHONE.getCode()).size();
        }
        if (ObjectUtils.isNotEmpty(groupMap.get(SubmissionMethodEnum.SMS.getCode()))) {
            smsSize = groupMap.get(SubmissionMethodEnum.SMS.getCode()).size();
        }
        String extraInfo = String.format("已调度电话%s起，短信%d批", phoneSize, smsSize);
        schedulingReportingDto.setExtraInfo(extraInfo);
        return schedulingReportingDto;
    }

    @Override
    public SchedulingReportingDto listReportingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingDto schedulingReportingDto = new SchedulingReportingDto();
        List<AlertSubmittedExtDto> alertSubmittedExtDtoList = this.baseMapper.listReportingByParam(queryParam);
        if (ObjectUtils.isNotEmpty(alertSubmittedExtDtoList)) {
            // 组装额外信息
            String _extraInfo = "报送给%s、%s";
            alertSubmittedExtDtoList.forEach(alertSubmittedExtDto -> {
                alertSubmittedExtDto.setExtraInfo(String.format(_extraInfo, alertSubmittedExtDto.getCompanyName(),
                        alertSubmittedExtDto.getUserName()));
                TemplateExtendDto template = templateService.getByType(alertSubmittedExtDto.getBusinessTypeCode());
                String richContent = template.getRichContent();
                alertSubmittedExtDto.setSubmissionContentValue(JSONObject.parseObject(alertSubmittedExtDto.getSubmissionContent()));
                alertSubmittedExtDto.setSubmissionContent(richContent);
            });
            schedulingReportingDto.setSchedulingReportingList(alertSubmittedExtDtoList);

            String extraInfo = String.format("已报送%d条", alertSubmittedExtDtoList.size());
            schedulingReportingDto.setExtraInfo(extraInfo);
        }
        return schedulingReportingDto;
    }

    @Override
    public Boolean save(AlertSubmittedDto alertSubmittedDto, String userName) throws Exception {
        Long alertSubmittedId = saveAlertSubmitted(alertSubmittedDto, userName);
        // 组装规则入参
        AlertCalled alertCalled = alertCalledService.getById(alertSubmittedDto.getAlertCalledId());
        AlertCalledObjsDto alertCalledVo = new AlertCalledObjsDto();
        alertCalledVo.setAlertCalled(alertCalled);
        List<AlertFormValue> alertFormValue = new ArrayList<>();
        AlertFormValue formValue = new AlertFormValue();
        formValue.setFieldCode("alertSubmittedId");
        formValue.setFieldValue(alertSubmittedId.toString());
        alertFormValue.add(formValue);
        alertCalledVo.setAlertFormValue(alertFormValue);

        // 调用规则
        ruleAlertCalledService.fireAlertCalledRule(alertCalledVo);
        return true;
    }

    /**
     * 规则回调
     */
    public void ruleCallbackAction(String smsCode, String sendIds, Object object) throws Exception {
        // 获取报送对象列表
        List<AlertSubmittedObject> alertSubmittedObjectList = Lists.newArrayList();

        Set<String> mobiles = new HashSet<>();
        HashMap<String, String> smsParams = new HashMap<>();
        String alertCalledId = null;
        // 根据id列表查询所有人员信息
        List<Long> ids = StringUtil.String2LongList(sendIds);
        if (object instanceof AlertCalledRo) {
            AlertCalledRo calledRo = (AlertCalledRo) object;
            String alertSubmittedId = calledRo.getAlertSubmittedId();
            alertCalledId = calledRo.getSequenceNbr();

            // 警情初报
            if (alertSubmittedId == null) {
                // 1.保存警情记录主表
                AlertSubmitted alertSubmitted = new AlertSubmitted();
                alertSubmitted.setAlertCalledId(Long.valueOf(calledRo.getSequenceNbr()));
                // 保存初报细分类型（一般火灾、航空器救援等）
                alertSubmitted.setBusinessTypeCode(calledRo.getAlertTypeCode());
                // 名称统一为警情初报
                alertSubmitted.setBusinessType(AlertBusinessTypeEnum.警情初报.getName());
                Optional<SubmissionMethodEnum> submissionMethodEnum = Optional.of(SubmissionMethodEnum.SMS);
                alertSubmitted.setSubmissionMethodCode(submissionMethodEnum.get().getCode());
                alertSubmitted.setSubmissionMethod(submissionMethodEnum.get().getName());
                Optional<AlertSchedulingTypeEnum> alertSchedulingTypeEnum = Optional.of(AlertSchedulingTypeEnum.融合调度);
                alertSubmitted.setSchedulingTypeCode(alertSchedulingTypeEnum.get().getCode());
                alertSubmitted.setSchedulingType(alertSchedulingTypeEnum.get().getName());
                alertSubmitted.setSubmissionContent(JSONObject.toJSONString(objectToMap(calledRo)));
                String token = RequestContext.getToken();
                ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildKey(token)).toString(),
                        ReginParams.class);
                alertSubmitted.setRecUserName(reginParams.getUserModel().getUserName());
                alertSubmitted.setSender(reginParams.getUserModel().getUserName());
                alertSubmitted.setUpdateTime(new Date());
                alertSubmitted.setSubmissionTime(new Date());

                this.baseMapper.insert(alertSubmitted);
                alertSubmittedId = alertSubmitted.getSequenceNbr().toString();
                Optional<AlertBusinessTypeEnum> alertBusinessTypeEnum =
                        EnumsUtils.getEnumObject(AlertBusinessTypeEnum.class,
                        e -> e.getCode().equals(calledRo.getAlertTypeCode()));
                smsCode = alertBusinessTypeEnum.get().getSms_code();
            }
            // 组装人员信息
            List<Map<String, Object>> orgUsers = orgUsrService.selectForShowByListId(ids);

            for (Map<String, Object> orgUser : orgUsers) {
                AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                alertSubmittedObject.setAlertSubmittedId(Long.parseLong(alertSubmittedId));
                alertSubmittedObject.setType(false);
                alertSubmittedObject.setCompanyId(Long.valueOf((String) orgUser.get("parentId")));
                alertSubmittedObject.setCompanyName((String) orgUser.get("parenName"));
                alertSubmittedObject.setUserId(Long.valueOf(String.valueOf(orgUser.get("sequenceNbr"))));
                alertSubmittedObject.setUserName((String) orgUser.get("bizOrgName"));
                alertSubmittedObject.setUserPhone((String) orgUser.get("telephone"));

                if (!ValidationUtil.isEmpty(orgUser.get("telephone"))) {
                    mobiles.add((String) orgUser.get("telephone"));
                }
                alertSubmittedObjectList.add(alertSubmittedObject);
            }
            // 组装报送内容
            smsParams.put("callTimeStr", calledRo.getCallTimeStr());
            smsParams.put("address", calledRo.getAddress());
            smsParams.put("fireLocation", calledRo.getFireLocation());
            smsParams.put("burningMaterial", calledRo.getBurningMaterial());
            smsParams.put("fireSituation", calledRo.getFireSituation());
            smsParams.put("trappedNum", calledRo.getTrappedNum());
            smsParams.put("casualtiesNum", calledRo.getCasualtiesNum());
            smsParams.put("dangerousExplosives", calledRo.getDangerousExplosives());
            smsParams.put("companyName", calledRo.getCompanyName());
        }
        // 短信报送对象
        alertSubmittedObjectServiceImpl.saveBatch(alertSubmittedObjectList);
        // 发送任务消息
        // 组织短信内容
        // 调用短信发送接口
        alertCalledAction.sendAlertCalleCmd(smsCode, mobiles, smsParams);

        emqKeeper.getMqttClient().publish(topic, alertCalledId.getBytes(), RuleConfig.DEFAULT_QOS, false);
    }

    /**
     * 短信报送
     *
     * @param alertSubmittedDto 警情信息
     * @param userName          用户名
     */
    @Transactional(rollbackFor = Exception.class)
    public Long saveAlertSubmitted(AlertSubmittedDto alertSubmittedDto, String userName) {
        Long alertSubmittedId = alertSubmittedDto.getSequenceNbr();
        String smsCode = "";
        Set<String> mobiles = new HashSet<>();
        if (alertSubmittedId == null) {

            // 1.保存警情记录主表
            AlertSubmitted alertSubmitted = new AlertSubmitted();
            alertSubmitted.setAlertCalledId(alertSubmittedDto.getAlertCalledId());
            alertSubmitted.setBusinessTypeCode(alertSubmittedDto.getBusinessTypeCode());
            Optional<AlertBusinessTypeEnum> businessTypeEnum = EnumsUtils.getEnumObject(AlertBusinessTypeEnum.class,
                    e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
            alertSubmitted.setBusinessType(businessTypeEnum.get().getName());
            alertSubmitted.setCallLogId(alertSubmittedDto.getCallLogId());
            alertSubmitted.setSubmissionMethodCode(alertSubmittedDto.getSubmissionMethodCode());
            Optional<SubmissionMethodEnum> submissionMethodEnum = EnumsUtils.getEnumObject(SubmissionMethodEnum.class,
                    e -> e.getCode().equals(alertSubmittedDto.getSubmissionMethodCode()));
            alertSubmitted.setSubmissionMethod(submissionMethodEnum.get().getName());
            Optional<AlertSchedulingTypeEnum> alertSchedulingTypeEnum =
                    EnumsUtils.getEnumObject(AlertSchedulingTypeEnum.class,
                            e -> e.getCode().equals(alertSubmittedDto.getSchedulingTypeCode()));
            alertSubmitted.setSchedulingTypeCode(alertSubmittedDto.getSchedulingTypeCode());
            alertSubmitted.setSchedulingType(alertSchedulingTypeEnum.get().getName());
            alertSubmitted.setSubmissionContent(alertSubmittedDto.getSubmitContent().toJSONString());
            alertSubmitted.setSender(userName);
            alertSubmitted.setRecUserName(userName);
            alertSubmitted.setUpdateTime(new Date());
            alertSubmitted.setSubmissionTime(new Date());

            this.baseMapper.insert(alertSubmitted);

            alertSubmittedId = alertSubmitted.getSequenceNbr();
            smsCode = businessTypeEnum.get().getSms_code();
        }

        // 2.保存任务表
        List<AlertSubmittedObject> alertSubmittedObjectList = Lists.newArrayList();
        Long finalAlertSubmittedId = alertSubmittedId;
        // 报送给单位
        if (AlertSubmitTypeEnum.Org.getKey().equals(alertSubmittedDto.getType())) {
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                alertSubmittedObject.setAlertSubmittedId(finalAlertSubmittedId);
                alertSubmittedObject.setType(true);
                alertSubmittedObject.setCompanyId(company.getCompanyId());
                alertSubmittedObject.setCompanyName(company.getCompanyName());
                alertSubmittedObject.setRecUserName(userName);

                alertSubmittedObjectList.add(alertSubmittedObject);
            });
        } else {
            // 报送给个人
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                company.getPersonList().forEach(person -> {
                    AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                    alertSubmittedObject.setAlertSubmittedId(finalAlertSubmittedId);
                    alertSubmittedObject.setType(false);
                    alertSubmittedObject.setCompanyId(company.getCompanyId());
                    alertSubmittedObject.setCompanyName(company.getCompanyName());
                    alertSubmittedObject.setUserId(person.getPersonId());
                    alertSubmittedObject.setUserName(person.getPersonName());
                    alertSubmittedObject.setUserPhone(person.getPersonPhone());
                    alertSubmittedObject.setRecUserName(userName);
                    if (!ValidationUtil.isEmpty(person.getPersonPhone())) {
                        mobiles.add(person.getPersonPhone());
                    }
                    alertSubmittedObjectList.add(alertSubmittedObject);
                });
            });
        }
        alertSubmittedObjectServiceImpl.saveBatch(alertSubmittedObjectList);

        // 3.更新警情状态
        alertCalledService.updateAlertCalled(alertSubmittedDto.getAlertCalledId(),
                alertSubmittedDto.getBusinessTypeCode());

        if (AlertBusinessTypeEnum.警情结案.getCode().equals(alertSubmittedDto.getBusinessTypeCode())
                || AlertBusinessTypeEnum.非警情确认.getCode().equals(alertSubmittedDto.getBusinessTypeCode())) {
            // 查询本次警情调派的车辆
            List<String> transferCarIdList =
                    powerTransferService.queryTransferCarIdsByAlertCalledId(alertSubmittedDto.getAlertCalledId());
            List<CarStatusInfoDto> carStatusInfoDtoList = Lists.newArrayList();
            if (!ValidationUtil.isEmpty(transferCarIdList)) {
                transferCarIdList.forEach(carId -> {
                    CarStatusInfoDto carStatusInfo = new CarStatusInfoDto();
                    carStatusInfo.setSequenceNbr(carId);
                    carStatusInfo.setStatus(FireCarStatusEnum.执勤.getCode());
                    carStatusInfoDtoList.add(carStatusInfo);
                });
            }
            // 更新所有车辆状态为执勤
            equipFeignClient.updateCarStatus(carStatusInfoDtoList);
        }

        // 4.发送任务消息
        // 4.1组织短信内容
        HashMap<String, String> smsParams = new HashMap<>();
        JSONObject submitContent = alertSubmittedDto.getSubmitContent();
        smsParams.put("alertType", submitContent.get("alertType").toString());
        smsParams.put("trappedNum", submitContent.get("trappedNum").toString());
        smsParams.put("companyName", submitContent.get("companyName").toString());
        // 4.2调用短信发送接口
        alertCalledAction.sendAlertCalleCmd(smsCode, mobiles, smsParams);
        return finalAlertSubmittedId;
    }

    /**
     * 短信报送对象
     *
     * @param alertSubmittedObjectList 报送对象列表
     * @param smsCode                  短信模板code
     * @param mobiles                  电话号码列表
     * @param smsParams                报送内容
     */
    public void saveAlertSubmittedObject(List<AlertSubmittedObject> alertSubmittedObjectList, String smsCode,
                                         Set<String> mobiles, HashMap<String, String> smsParams) {


//        alertSubmittedObjectServiceImpl.saveBatch(alertSubmittedObjectList);
        // 发送任务消息
        // 组织短信内容
        // 调用短信发送接口
        alertCalledAction.sendAlertCalleCmd(smsCode, mobiles, smsParams);
    }

    public void getAlertSubmittedContent(Long alertCalledId, ArrayList<TemplateDto> templateDtos, String companyName) throws IllegalAccessException {
        AlertCalled alertCalled = alertCalledService.getById(alertCalledId);
        Map<String, Object> map = objectToMap(alertCalled);
        map.put("companyName", companyName);

        // 获取模板内容
        List<DataDictionary> dataDictionaries =
                dataDictionaryService.list(new QueryWrapper<DataDictionary>().eq("type",
                        "JQBSLX"));
        for (DataDictionary dataDictionary : dataDictionaries) {
            Template template = templateService.getOne(new QueryWrapper<Template>().eq("type_code",
                    dataDictionary.getCode()).eq("format", true));
            List<PowerTransferCompanyDto> lastPowerTransferCompany;
            if ("警情续报".equals(template.getType()) && (lastPowerTransferCompany =
                    powerTransferService.getLastPowerTransferCompany(alertCalledId)).size() > 0) {
                map.put("businessType", template.getType());
                // 获取力量调派内容
                StringBuilder companyNames = new StringBuilder();
                StringBuilder resourcesInfo = new StringBuilder();
                for (PowerTransferCompanyDto powerTransferCompanyDto : lastPowerTransferCompany) {
                    companyNames.append(powerTransferCompanyDto.getCompanyName()).append("、");
                    resourcesInfo.append(powerTransferCompanyDto.getType()).append(powerTransferCompanyDto.getResourcesCount()).append("辆、");
                }
                map.put("companyNames", companyNames.deleteCharAt(companyNames.length() - 1).toString());
                map.put("resourcesInfo", resourcesInfo.deleteCharAt(resourcesInfo.length() - 1).toString());
                map.put("transferTime", lastPowerTransferCompany.get(0).getRecDate());
            }
            TemplateDto templateDto = new TemplateDto();
            BeanUtils.copyProperties(template, templateDto);
            templateDto.setData(map);
            templateDtos.add(templateDto);
        }
    }

    @Override
    public AlertSubmittedSMSDto getSchedulingContent(Long id) {
        return this.baseMapper.getSchedulingContent(id);
    }

    @Override
    public List<InstructionsZHDto> getInstructionsZHDtoList(Long id) {

        List<InstructionsZHDto> listInstructionsZHDto=new ArrayList<>();

        //获取调派记录
        List<PowerTransferCompanyZHDto>  listPowerTransferCompanyZHDto=powerTransferCompanyMapper.listPowerTransferCompanyZHDto(id);

        listPowerTransferCompanyZHDto.stream().forEach(PowerTransferCompanyZHDto->{
            String content="";
            if(PowerTransferCompanyZHDto.getIsDistributionAgencies()){
                content="调派"+PowerTransferCompanyZHDto.getCompanyName()+"前往"+PowerTransferCompanyZHDto.getAddress();
            }else{
                content="调派"+PowerTransferCompanyZHDto.getCompanyName()+PowerTransferCompanyZHDto.getSubmissionContent()+"前往"+PowerTransferCompanyZHDto.getAddress();
            }
             InstructionsZHDto instruct = new InstructionsZHDto(PowerTransferCompanyZHDto.getSequenceNbr(),PowerTransferCompanyZHDto.getDispatchType(), PowerTransferCompanyZHDto.getRecDate(), content);
            listInstructionsZHDto.add(instruct);
        });



        //获取融合调度信息
        List<AlertSubmittedZHDto>  listAlertSubmittedZHDto= alertSubmittedMapper.listAlertSubmittedZHDto(id);

        listAlertSubmittedZHDto.stream().forEach(AlertSubmittedZHDto->{
            JSONObject js= JSONObject.parseObject(AlertSubmittedZHDto.getSubmissionContent());
            String content="";

            switch(AlertSubmittedZHDto.getBusinessType()){
                case "警情初报":


                    content="通知"+ AlertSubmittedZHDto.getCompanyName()+":"+AlertSubmittedZHDto.getUserName()+","+js.getString("address")+"发生"+js.getString("alertType");

                    break;
                case "警情续报":

                    content="通知"+ AlertSubmittedZHDto.getCompanyName()+":"+AlertSubmittedZHDto.getUserName()+","+"现场被困人数："+js.getString("trappedNum")+"人伤亡人数："+js.getString("casualtiesNum")+"人。";

                    break;
                case "非警情确认":

                    content="通知"+ AlertSubmittedZHDto.getCompanyName()+":"+AlertSubmittedZHDto.getUserName()+","+"此警情现场确认为假警情。";

                    break;
                case "警情结案":
                    content="通知"+ AlertSubmittedZHDto.getCompanyName()+":"+AlertSubmittedZHDto.getUserName()+","+"此警情已完场警情处置，警情已结案。";
                    break;

                default:

                    break;
            }

            InstructionsZHDto instruct = new InstructionsZHDto(AlertSubmittedZHDto.getSequenceNbr(),AlertSubmittedZHDto.getBusinessType(), AlertSubmittedZHDto.getSubmissionTime(), content);
            listInstructionsZHDto.add(instruct);

        });

        //排序时间倒序

        List<InstructionsZHDto>  listA=listInstructionsZHDto.stream().sorted(Comparator.comparing(InstructionsZHDto::getSubmissionTime).reversed()).collect(Collectors.toList());


        return listA;
    }

    /**
     * 将Object对象里面的属性和值转化成Map对象
     *
     * @param obj 源对象
     * @return 转化结果
     * @throws IllegalAccessException IllegalAccessException
     */
    @SuppressWarnings("unchecked")
    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<>();
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();

        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if ("dynamicFormAlert".equalsIgnoreCase(fieldName)) {
                List<FormValue> dynamicFormAlert = (List<FormValue>) field.get(obj);
                for (FormValue formValue : dynamicFormAlert) {
                    map.put(formValue.getLabel(), formValue.getValue());
                }
            } else {
                Object value = field.get(obj);
                map.put(fieldName, value);
            }
        }
        return map;
    }
}
