package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersJacketDto;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersJacket;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersJacketMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.EquipSpecificDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.EquipmentOnCarDto;
import com.yeejoin.amos.boot.module.jcs.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.jcs.api.service.IFirefightersJacketService;

/**
 * 消防人员配装记录 服务实现类
 *
 * @author tb
 * @date 2021-06-07
 */
@Service
public class FirefightersJacketServiceImpl extends BaseService<FirefightersJacketDto, FirefightersJacket, FirefightersJacketMapper> implements IFirefightersJacketService {

    @Autowired
    private EquipFeignClient equipFeignClient;

    @Override
    public ResponseModel<Page<EquipmentOnCarDto>> getAirEquipSpecificPage(EquipSpecificDto equipSpecificDto, int current, int size) {
        Page page = new Page(current, size);
        equipSpecificDto.setPage(page);
        ResponseModel<Page<EquipmentOnCarDto>> airEquipSpecificPage = equipFeignClient.getAirEquipSpecificPage(equipSpecificDto);
        return airEquipSpecificPage;
    }

    @Override
    public boolean saveOrUpdateBatch(Long firefightersId, List<EquipmentOnCarDto> equipmentOnCarDtos) {
        List<Long> ids = equipmentOnCarDtos.stream().map(EquipmentOnCarDto::getStockDetailId).collect(Collectors.toList());
        List<Object> result = equipFeignClient.stockBindEquip(ids).getResult();
        if (result.size() > 0) {
            List<FirefightersJacket> firefightersJackets = new ArrayList<>();
            equipmentOnCarDtos.forEach(x -> {
                FirefightersJacket firefightersJacket = new FirefightersJacket();
                BeanUtils.copyProperties(x, firefightersJacket);
                firefightersJacket.setEquipmentDetailId(x.getEquipmentSpecificId());
                firefightersJacket.setEquipmentDetailName(x.getEquipmentSpecificName());
                firefightersJacket.setEquipmentTypeName(x.getEquipDefinitionName());
                firefightersJacket.setAllotmentTime(DateUtils.getDateNow());
                firefightersJacket.setFirefightersId(firefightersId);
                firefightersJackets.add(firefightersJacket);
            });
            saveOrUpdateBatch(firefightersJackets);
            return true;
        }
        return false;
    }

    @Override
    public boolean update(String type, FirefightersJacket firefightersJacket) {
        ResponseModel<Object> objectResponseModel = null;
        if (EquipTypeEnum.退装.getKey().equals(type)) {
            objectResponseModel = equipFeignClient.scrapEquip(String.valueOf(firefightersJacket.getStockDetailId()));
        } else if (EquipTypeEnum.回库.getKey().equals(type)) {
            Map<String, Object> map = new HashMap<>();
            map.put("stockDetailId", firefightersJacket.getStockDetailId());
            objectResponseModel = equipFeignClient.stockEquip(map);
        }
        if (ValidationUtil.isEmpty(objectResponseModel)){
            return false;
        }
        update(new UpdateWrapper<FirefightersJacket>().eq("sequence_nbr", firefightersJacket.getSequenceNbr()).set("is_delete", 1));
        return true;
    }

    @Override
    public ResponseModel<Object> getEquipByStockDetailId(Long stockDetailId) {
        return equipFeignClient.getAirEquipSpecificDetail(stockDetailId);
    }
}
