package com.yeejoin.amos.boot.module.tzs.biz.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.tzs.api.service.IEquipmentCategoryService;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqxListener;

/**
 * @author Administrator
 */
@Component
public class AmosMqttListener extends EmqxListener {

    @Autowired
    IEquipmentCategoryService equipmentCategoryService;

    @Override
    public void processMessage(String topic, MqttMessage mqttMessage){
        byte[] payload = mqttMessage.getPayload();
        String str = new String(payload);
        String msg = JSON.parse(str).toString();
        JSONObject jsonObject = JSONObject.parseObject(msg);
        String id = jsonObject.get("id").toString();
        equipmentCategoryService.createSupervisorCode(null, id);
    }
}
