package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum GenStageEnum {
    /**
     * 质量问题产生阶段
     */
    HJGY("1", "焊接工艺"),
    HKTS("2", "焊口探伤"),
    GDMS("3", "管道埋深"),
    NYCS("4", "耐压测试"),
    FSDW("5", "敷设定位"),

    /**
     * 监管指标类型
     */
    NUM_TYPE("numType", "数值型"),
    SYMBOL_TYPE("symbolType", "符号型"),

    /**
     * 监管指标类型对应值的枚举
     */
    NUM_TYPE_START("NUM_TYPE_START", "最小值"),
    NUM_TYPE_END("NUM_TYPE_END", "最大值"),
    SYMBOL_TYPE_START("SYMBOL_TYPE_START", "正常"),
    SYMBOL_TYPE_END("SYMBOL_TYPE_END", "异常");

    private final String code;
    private final String name;

    public String getCode() {
        return code;
    }
    public String getName() {
        return name;
    }

    public static String getTypeByCode(String code){
        for (GenStageEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }
}
