package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ugp.api.Enum.TabLogoEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.OverProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectInitiationService;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectInitiationServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectOverFlowServiceImpl;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;

/**
 * 小您过目结项流程相关API
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目结项流程Api")
@RequestMapping(value = "/projectOver")
public class ProjectOverFlowController extends BaseController {

    @Resource
    private ProjectServiceImpl projectServiceImpl;

    @Resource
    private IProjectInitiationService iProjectInitiationService;

    @Resource
    private ProjectInitiationServiceImpl projectInitiationServiceImpl;

    @Autowired
    ProjectOverFlowServiceImpl projectOverFlowService;


    /**
     * 项目结项流程启动API
     *
     * @param jsonObject 表单信息： 项目结项信息  key为：{@link TabLogoEnum}
     */
    @PostMapping(value = "/flowStart")
    @ApiOperation(value = "项目竣工结项（竣工结项确认）- 结项项目结项流程启动API", notes = "项目竣工结项（竣工结项确认）- 项目结项流程启动API")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<Object> overProjectFlowStart(@RequestBody JSONObject jsonObject) {
        OverProjectDto dto = JSON.parseObject(JSON.toJSONString(jsonObject.get(TabLogoEnum.项目竣工信息.getLogo())), OverProjectDto.class);
        dto.setProjectId(jsonObject.getLong("projectId"));
        dto.setCondition(jsonObject.getString("condition"));
        String token = RequestContext.getToken();
        String appKey = RequestContext.getAppKey();
        String product = RequestContext.getProduct();
        //分支线程执行流程
        Thread t1 = new Thread(() -> {
            RequestContext.setToken(token);
            RequestContext.setAppKey(appKey);
            RequestContext.setProduct(product);
            iProjectInitiationService.overProjectFlowStart(dto);
        });
        t1.start();
        return ResponseHelper.buildResponse(dto);
    }

    /**
     * 项目结项执行流程
     *
     * @param jsonObject @param jsonObject 表单信息： 项目结项信息  key为：{@link TabLogoEnum}
     */
    @PostMapping(value = "/flowExecute")
    @ApiOperation(value = "项目结项流程执行通用API", notes = "项目结项流程执行通用API")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<Object> overProjectFlowExecute(@RequestBody JSONObject jsonObject) {
        OverProjectDto dto = JSON.parseObject(JSON.toJSONString(jsonObject.get(TabLogoEnum.项目竣工信息.getLogo())), OverProjectDto.class);
        dto.setProjectId(jsonObject.getLong("projectId"));
        dto.setCondition(jsonObject.getString("condition"));
        iProjectInitiationService.overProjectFlowExecute(dto);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(value = "根据项目表sequenceNbr查询结项流程相关信息", notes = "根据项目表sequenceNbr查询结项流程相关信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel<OverProjectDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(projectOverFlowService.selectOne(sequenceNbr));
    }
}
