package com.yeejoin.amos.boot.biz.config;


import org.apache.commons.lang.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2022/9/7
 */
@Configuration
public class RedissonConfig {
    @Autowired
    private RedisConfigProperties redisConfigProperties;


    private  volatile  static RedissonClient redissonClient;
    /**
     * 集群模式的 redisson 客户端
     *
     * @return
     */
    @Bean
    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "cluster")
    public RedissonClient redissonClient() {

        //redisson版本是3.5，集群的ip前面要加上“redis://”，不然会报错，3.2版本可不加
        if(redissonClient==null){
            synchronized (RedissonConfig.class){
               if(redissonClient==null){
                   List<String> clusterNodes = new ArrayList<>();
                   System.out.println("cluster redisProperties:" + redisConfigProperties.getCluster().toString());
                   for (int i = 0; i < redisConfigProperties.getCluster().getNodes().size(); i++) {
                       clusterNodes.add("redis://" + redisConfigProperties.getCluster().getNodes().get(i));
                   }
                   Config config = new Config();

                   ClusterServersConfig clusterServersConfig = config.useClusterServers()
                           //设置集群扫描时间
                           .setScanInterval(5000) // 集群状态扫描间隔时间，单位是毫秒
                           .setTimeout(30000)
                           //主节点线程池数量
                           .setMasterConnectionPoolSize(20)
                           //从节点线程池数量
                           .setSlaveConnectionPoolSize(20)
                           .setIdleConnectionTimeout(10000)
                           .setSlaveConnectionMinimumIdleSize(20)
                           .setMasterConnectionMinimumIdleSize(20)
                           .addNodeAddress(clusterNodes.toArray(new String[clusterNodes.size()]));
                   clusterServersConfig.setCheckSlotsCoverage(false);
                   // 设置密码
                   if (StringUtils.isNotBlank(redisConfigProperties.getPassword())) {
                       clusterServersConfig.setPassword(redisConfigProperties.getPassword());
                   }
                   redissonClient = Redisson.create(config);
               }
            }

        }
        return redissonClient;
    }


    /**
     * 单机模式 redisson 客户端
     */

//    @Bean
//    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "single")
//    RedissonClient redissonSingle() {
//        Config config = new Config();
//        String node = redisConfigProperties.getRedissonUrl();
//        node = node.startsWith("redis://") ? node : "redis://" + node;
//        SingleServerConfig serverConfig = config.useSingleServer()
//                .setAddress(node);
//        if (StringUtils.isNotBlank(redisConfigProperties.getPassword())) {
//            serverConfig.setPassword(redisConfigProperties.getPassword());
//        }
//        return Redisson.create(config);
//    }


}