package com.yeejoin.amos.boot.module.common.api.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.dto.DutyCarDto;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IDutyCarService extends IDutyCommonService {

    /**
     * 值班信息保存
     * @param dutyCarDto 对象
     * @return List<DutyCarDto>
     */
    DutyCarDto save(DutyCarDto dutyCarDto);

    /**
     * 更新
     * @param instanceId 实例id
     * @param dutyCarDto 业务对象
     * @return List<DutyCarDto>
     */
    DutyCarDto update(Long instanceId, DutyCarDto dutyCarDto);

    /**
     * 判断当前登陆人是否是车辆驾驶员
     *
     * @return
     */
    JSONObject isFireCarDriver();
    int getDutyCarCount(Long carId);
    List<Map<String, Object>> getDutyCaruser(Long carId);

    List<Map<String, Object>> theCarDutyPerson(Long carId);

    //查询今日值班车辆
    List<Map<String, String>>getDutyCar();

    void writeHistoryDutyLog();
}
