package com.yeejoin.equipmanage.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author DELL
 */

@Getter
@AllArgsConstructor
public enum ConfigPageTopicEnum {

    INTEGRATE("$share/AMOS-EQUIPMANAGE/INTEGRATE_TOPIC/#", "集成页面统配主题");

	private String topic;

    private String describe;
    
    
    public static List<String> getEnumTopicList() {
        List<String> topics = new ArrayList<>();
        for (ConfigPageTopicEnum e : ConfigPageTopicEnum.values()) {
        	topics.add(e.getTopic());
       }
        return topics;
    }
    
    public static boolean  isEqualsTopic(String topic) {
        for (ConfigPageTopicEnum e : ConfigPageTopicEnum.values()) {
        	if(e.getTopic().equals(topic)){
        		 return true;
        	}
       }
        return false;
    }
}
