package com.yeejoin.amos.boot.module.jcs.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * 
 * <pre>
 * 警情信息ES实体
 * </pre>
 *
 * @author gwb
 * @version $Id: ESAlertCalled.java, v 0.1 2021年6月19日 下午5:12:31 gwb Exp $
 */
@Data
@Accessors(chain = true)
@Document(indexName = "jcs", type = "alertCalled", shards = 3, replicas = 1)
public class ESAlertCalled {

    /** 主键 */
    @Id
    private Long sequenceNbr;
    /**
     * 警情状态
     */
    @Field(type = FieldType.Boolean, index = false)
    private Boolean alertStatus;
    /**
     * 警情状态
     */
    @Field(type = FieldType.Text)
    private String alertStatusStr;
    /**
     * 响应级别字典code 为了过滤用（只有航空器故障有）
     */
    @Field(type = FieldType.Text, index = false)
    private String responseLevelCode;
    /**
     * 警情阶段
     */
    @Field(type = FieldType.Text, index = false)
    private String alertStage;
    /**
     * 联系人姓名
     */
    @Field(type = FieldType.Text)
    private String contactUser;
    /**
     * 联系人电话
     */
    @Field(type = FieldType.Text)
    private String contactPhone;
    /**
     * 接警时间
     */
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time, index = false)
    private Date callTime;
    /**
     * 接警时间
     */
    @Field(type = FieldType.Long)
    private Long callTimeLong;
    /**
     * 警情类型
     */
    @Field(type = FieldType.Text, index = false)
    private String alertType;
    /**
     * 警情类型Code
     */
    @Field(type = FieldType.Text)
    private String alertTypeCode;
    /**
     * 事发单位
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String unitInvolved;
    /**
     * 地址
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String address;
    /**
     * 坐标x
     */
    private Double coordinateX;
    /**
     * 坐标y
     */
    private Double coordinateY;

    /**
     * 落地时间
     */
    @Field(type = FieldType.Long)
    private Long landingTime;

    /**
     *航班号
     */
    @Field(type = FieldType.Text)
    private String forcedLandingTrack;


    /**
     *迫降跑道
     */
    @Field(type = FieldType.Text)
    private String flightNumber;

    /**
     * 落地时间
     */
    @Field(type = FieldType.Long)
    private Long taskTime;


}
