package com.yeejoin.amos.knowledgebase.face.orm.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@Document(indexName = "knowledgebase", type = "doc", shards = 3, replicas = 1)
public class ESDocEntity {

    /** 主键 */
    @Id
    private Long sequenceNbr;

    /** 文档标题 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String docTitle;

    /** 主键 */
    private Long directoryId;

    /** 分类 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_smart")
    private String directoryName;

    /** 作者 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_smart")
    private String author;

    /** 发布时间 */
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time)
    private Date lastUpdateTime;

    /** 正文文字 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String textContent;

    /** 基本信息 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_max_word")
    private String docInfo;

    /** 文档正文HTML */
    private String htmlContent;

    /** 文档摘要 */
    private String summary;

    /** 文档标签 */
    @Field(type = FieldType.Nested, includeInParent = true)
    private List<ESTagEntity> docTags;

    /** 文档内容标签 */
    @Field(type = FieldType.Nested, includeInParent = true)
    private List<ESTagEntity> contentTags;

    private String docJson;

    @Field(type = FieldType.Keyword)
    private String sortStr;

}
