package com.yeejoin.amos.knowledgebase.face.orm.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Parent;

@Data
@Accessors(chain = true)
@Document(indexName = "knowledgebase",type = "tag", shards = 3, replicas = 1)
public class ESTagEntity {

    /** 主键 */
    @Id
    private Long sequenceNbr;

    private Long tagSeq;

    /** 标签名称 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String tagName;

    /** 标签值信息 */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_smart", analyzer = "ik_smart")
    private String tagInfo;

    /**原生数据*/
    private String tagJson;

    /** 绑定外键 */
    @Parent(type = "doc")
    private String docId;

}
