package com.yeejoin.amos.knowledgebase.face.util.excel;

import lombok.Data;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.List;
import java.util.Map;

@Data
public class ExcelImportConfig {

    /**
     * 终止行号
     */
    private Integer stopColIndex;
    /**
     * 起始行
     */
    private Integer startRowIndex;
    /**
     * 标签与列对应关系
     */
    private Map<Long, List<Integer>> tagColumns;
    /**
     * 基本信息与列对应关系
     */
    private Map<String, Integer> basicColumns;
    /**
     * 列数据格式化方式
     */
    private Map<Integer, String> formatMap;

    /**
     * 列数据对应枚举
     */
    private Map<Integer, String> enumMap;

    /**
     * 文档正文模板
     */
    private String htmlModule;

    /**
     * 文档摘要模板
     */
    private String summaryModule;

    /**
     * 文档标题列
     */
    private Integer titleColumn;

    /**
     * 文档分类列
     */
    private String directoryColumn;

    /**
     * 完整性检查
     *
     * @return 是否完整
     */
    public boolean check() {
        if (ValidationUtil.isEmpty(startRowIndex)
                || null == tagColumns
                || null == basicColumns
                || null == formatMap
                || null == enumMap
                || null == titleColumn
                || null == directoryColumn
                || ValidationUtil.isEmpty(htmlModule)) {
            return false;
        }
        for (List<Integer> colIndexList : tagColumns.values()) {
            if (ValidationUtil.isEmpty(colIndexList)
                    || ValidationUtil.isEmpty(colIndexList.get(0))) {
                return false;
            }
            for (Integer colIndex : colIndexList) {
                if (ValidationUtil.isEmpty(colIndex)) {
                    return false;
                }
            }
        }
        for (Integer value : basicColumns.values()) {
            if (ValidationUtil.isEmpty(value)) {
                return false;
            }
        }
        return true;
    }

}
