package com.yeejoin.amos.boot.module.common.biz.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DynamicGroupCode {

    JCS_PERSON("机场人员", "246"),
    JCS_YIJ("一级", "852"),
    JCS_ERJ("二级", "853"),
    JCS_SANJ("三级", "854"),
    JCS_SIJ("四级", "855");

    private String name;
    private String code;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static DynamicGroupCode getEnum(String name) {
        for (DynamicGroupCode bEnum : DynamicGroupCode.values()) {
            if (bEnum.getName().equals(name)) {
                return bEnum;
            }
        }
        return null;
    }
}
