package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.Equipment;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentAppVO;
import com.yeejoin.equipmanage.common.vo.EquipmentVo;
import com.yeejoin.equipmanage.common.entity.vo.ImportantEquipmentVO;
import com.yeejoin.equipmanage.dto.EquipmentcountDto;

import java.util.List;
import java.util.Map;

/**
 * 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IEquipmentService extends IService<Equipment> {

    /**
     * <pre>
     * 按条件分页查询装备定义信息
     * </pre>
     *
     * @param daoCriteria 查询条件
     * @param maxResult   每页显示的记录条数
     * @param firstResult 结果集的开始处
     * @return 装备定义信息集合
     */
    public List<Map<String, Object>> getWlZbdyByCondition(String daoCriteria, String isIot, Long maxResult, Long firstResult);

    /**
     * <pre>
     * 按条件查询装备定义总数
     * </pre>
     *
     * @param daoCriteria 名称
     */
    public Long getWlZbdyRowNum(String daoCriteria);

    /**
     * <pre>
     * 按id批量装备定义总数
     * </pre>
     *
     * @param idList id集合
     */
    void deleteEquipments(List<Long> idList) throws IllegalArgumentException;

    /**
     * <pre>
     * 新增装备定义
     * </pre>
     */

    boolean addEquipmentDef(Equipment equipment) throws IllegalArgumentException;

    /**
     * <pre>
     * 编辑装备定义
     * </pre>
     */
    boolean editEquipmentDef(Equipment equipment1) throws IllegalArgumentException;

    /**
     * 通过装备定义id分页查询性能指标
     *
     * @param maxResult
     * @param firstResult
     * @return
     */
    public List<Map<String, Object>> queryPerfQuotaByCondition(Long equipId, Long maxResult, Long firstResult);


    public long countPerfQuotaByCondition(Long equipId);

    /**
     * 根据装备分类获取装备定义
     *
     * @param categoryId
     * @return
     */
    List<Equipment> findAllByCategoryId(Long categoryId);


    List<Equipment> listByCategoryId(Long categoryId);

    /**
     * app查询设备详情
     *
     * @return
     */
    EquipmentAppVO getEquipmentAppMessage(String qrCode);


    String checkDelete(List<Long> ids);

    /**
     * 通过id数组获取重点设别列表
     *
     * @param ids
     * @return
     */
    List<ImportantEquipmentVO> getImportantEquipmentList(List<Long> ids);

    List<EquipmentVo> getEquipListBySpecific();
    /**
     * 获取装备的编码和名称 
     * @author 陈浩 on 2021.07.15
     * @return
     */
    List<Map<String, Object>>  getEquipmentNameAndCode();

    /**
     * 查询所有装备定义
     * @return List<Equipment>
     */
    List<Equipment> getAll();
    /**
     * 
     * <pre>
     * 根据装备id查询所属装备定义
     * </pre>
     *
     * @param equipmentSpecificId
     * @return
     */
    EquipmentVo getEquipBySpecific(Long equipmentSpecificId);

    /**
     *
     * 装备统计
     * */
    List<EquipmentcountDto>  getEquipmentcount(String name,String code);


}
