package com.yeejoin.amos.fas.business.scheduled;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.yeejoin.amos.fas.business.service.intfc.IContingencyInstance;
import org.typroject.tyboot.core.foundation.context.RequestContext;

@Component
public class FireScheduled {

	private static final Logger log = LoggerFactory.getLogger(FireScheduled.class);

//	private static LinkedList<Map<String, String>> fireQueue = new LinkedList<>();
    @Autowired
    IContingencyInstance iContingencyInstance;

	@Autowired(required = false)
	RedissonClient redisson;
	@Autowired
	private RedisUtils redisUtils;
	@Value("${spring.redis.mode}")
	private String cluster;

//	@Scheduled(cron = "*/2 * * * * ?")
//	public void runFireQueue() throws Exception {
//
//        if("cluster".equals(cluster)){
//
//		DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
//		String time=format.format(new Date());
//		String jobName = "fas-1" + time;
//
//
//		RLock lock = redisson.getLock(jobName);
//		try {
//			//拿锁失败10停止尝试， 任务执行超时默认续30s 每个10秒续到30
//			lock.tryLock(10, TimeUnit.SECONDS);
//			System.out.println("获取锁成功============");
//			//为了防止重复
//			if (!redisUtils.hasKey(jobName + "_redisson_key")) {
//				redisUtils.set(jobName + "_redisson_key", "1");//
//
//
//				if (fireQueue.size() == 0)
//					return;
//
//				Map<String, String> map = fireQueue.getFirst();
//				String batchNo = map.get("batchNo");
//				String stepCode = map.get("stepCode");
//				String buttonCode = map.get("buttonCode");
//				String confirm = map.get("confirm");
//				String contingencyPlanId = map.get("contingencyPlanId");
//				String stepState = map.get("stepState");
////		String token = map.get("token");
////		String product = map.get("product");
//
//				log.info("fireQueue-size:" + fireQueue.size());
//				log.info("stepCode:" + map.get("stepCode"));
//				log.info("buttonCode:" + map.get("buttonCode"));
//				log.info("confirm:" + map.get("confirm"));
//				log.info("stepState:" + map.get("stepState"));
////			RequestContext.setToken(token);
////			RequestContext.setProduct(product);
//				iContingencyInstance.setButtonExecuted(batchNo, contingencyPlanId, buttonCode, confirm);
//				iContingencyInstance.fire(batchNo, stepCode, contingencyPlanId, buttonCode, confirm, stepState);
//			}
//		} catch (Exception e) {
//			throw e;
//		} finally {
//			fireQueue.removeFirst();
//			lock.unlock(); //释放锁
//
//		}
//		}else{
//
//			if (fireQueue.size() == 0)
//				return;
//
//			Map<String, String> map = fireQueue.getFirst();
//			String batchNo = map.get("batchNo");
//			String stepCode = map.get("stepCode");
//			String buttonCode = map.get("buttonCode");
//			String confirm = map.get("confirm");
//			String contingencyPlanId = map.get("contingencyPlanId");
//			String stepState = map.get("stepState");
////		String token = map.get("token");
////		String product = map.get("product");
//
//			log.info("fireQueue-size:" + fireQueue.size());
//			log.info("stepCode:" + map.get("stepCode"));
//			log.info("buttonCode:" + map.get("buttonCode"));
//			log.info("confirm:" + map.get("confirm"));
//			log.info("stepState:" + map.get("stepState"));
////			RequestContext.setToken(token);
////			RequestContext.setProduct(product);
//			iContingencyInstance.setButtonExecuted(batchNo, contingencyPlanId, buttonCode, confirm);
//			iContingencyInstance.fire(batchNo, stepCode, contingencyPlanId, buttonCode, confirm, stepState);
//		}
//	}
//	public static LinkedList<Map<String, String>> getFireQueue() {
//		return fireQueue;
//	}
//	public static void setFireQueue(LinkedList<Map<String, String>> fireQueue) {
//		FireScheduled.fireQueue = fireQueue;
//	}





    @Async
	public void runFireQueue(Map<String, String> map) throws Exception {
			String batchNo = map.get("batchNo");
			String stepCode = map.get("stepCode");
			String buttonCode = map.get("buttonCode");
			String confirm = map.get("confirm");
			String contingencyPlanId = map.get("contingencyPlanId");
			String stepState = map.get("stepState");
		    String token = map.get("token");
		    String product = map.get("product");
		    String appKey = map.get("appKey");
			log.info("stepCode:" + map.get("stepCode"));
			log.info("buttonCode:" + map.get("buttonCode"));
			log.info("confirm:" + map.get("confirm"));
			log.info("stepState:" + map.get("stepState"));
			RequestContext.setToken(token);
			RequestContext.setProduct(product);
		    RequestContext.setProduct(appKey);
			iContingencyInstance.setButtonExecuted(batchNo, contingencyPlanId, buttonCode, confirm);
			iContingencyInstance.fire(batchNo, stepCode, contingencyPlanId, buttonCode, confirm, stepState);

	}






}
