package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrSafeReportDto;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;

/**
 * @description:
 * @author: tw
 * @createDate: 2022/11/16
 */
@RestController
@RequestMapping(value = "/user")
@Api(tags = "用户登录")
public class UserLoginController extends BaseController {


    @Autowired
    OrgUsrMapper orgUsrMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/login")
    @ApiOperation(httpMethod = "POST", value = "用户登录", notes = "用户登录")
    public Object save(@RequestBody IdPasswordAuthModel var1) {


        FeignClientResult result= Privilege.authClient.idpassword(var1);

        if (result.getResult() != null) {
            LinkedHashMap<String, Object>  jd=  (LinkedHashMap<String, Object>) result.getResult();
            String   id =jd.get("userId").toString();
            //验证用户是否绑定机场单位
            OrgUsr or=orgUsrMapper.queryByUserId(Long.valueOf(id));
            if(or!=null){
                return result;
            }else{
                result.setDevMessage("FAILED");
                result.setMessage("未绑定机场单位用户，请联系管理员！");
                result.setStatus(401);
                return result;
            }
        }
        return null;
    }


}
