package com.yeejoin.amos.maintenance.task;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.maintenance.business.service.intfc.IPlanTaskService;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * @author DELL
 */
@Component
@EnableScheduling
public class PlanTaskJob {

    @Autowired(required = false)
    org.redisson.api.RedissonClient redisson;

    @Value("${spring.redis.mode}")
    private String cluster;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private IPlanTaskService planTaskService;

    /**
     * 定时查询任务状态
     */
    @Scheduled(cron = "${jobs.cron}")
    public void scheduleJob() {

      if("cluster".equals(cluster)){
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String time=format.format(new Date());
        String jobName = "maintenance-1" + time;


        RLock lock = redisson.getLock(jobName);
        try {
            //拿锁失败10停止尝试， 任务执行超时默认续30s 每个10秒续到30
            //拿锁失败10停止尝试，20秒后直接释放锁 无论是返回 true 还是 false，都会继续执行之后的代码。
            lock.tryLock(10, 20, TimeUnit.SECONDS);
            System.out.println("获取锁成功============");
            //为了防止重复
            if (!redisUtils.hasKey(jobName + "_redisson_key")) {
                redisUtils.set(jobName + "_redisson_key", "1");//
                planTaskService.taskExecution(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            lock.unlock(); //释放锁
        }
      }else{

              planTaskService.taskExecution(null);

      }


    }

    /**
     * 定时任务推送维保待办任务消息
     */
    @Scheduled(cron = "${jobs.cron}")
    public void taskMessage() {
        if("cluster".equals(cluster)) {
            DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String time = format.format(new Date());
            String jobName = "maintenance-2" + time;

            RLock lock = redisson.getLock(jobName);
            try {
                //拿锁失败10停止尝试，20秒后直接释放锁 无论是返回 true 还是 false，都会继续执行之后的代码。
                lock.tryLock(10, 20, TimeUnit.SECONDS);
                System.out.println("获取锁成功============");
                //为了防止重复
                if (!redisUtils.hasKey(jobName + "_redisson_key")) {
                    redisUtils.set(jobName + "_redisson_key", "1");//
                    planTaskService.taskMessage(null);
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                lock.unlock(); //释放锁
            }
        }else{
            planTaskService.taskMessage(null);
        }


    }
}
