package com.yeejoin.amos.patrol.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.patrol.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.dao.entity.PointInputItem;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.patrol.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.business.vo.InputItemVo;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import org.springframework.stereotype.Repository;

@Repository
@Mapper
public interface InputItemMapper extends BaseMapper<InputItem> {

    /**
     * 新接口
     * */
    public long countInputItemInfoDataNew(InputItemPageParam param);

    Map<String, String> getCategoryByCode(@Param("code") String code, @Param("industryCode") String industryCode);

    Map<String, String> getCategoryById(@Param("id") String id);

    List<Map<String, String>> getAllCategoryName();

    public List<InputItemVo> getInputItemInfoNew(InputItemPageParam param);

    Map<Long, Long> getAllCountInfo();

    Map<String,String> getEquipParentCode(String code);

    Map<String,String> getSystemParentCode(String id);

    Map<String,String> getEquipParent(String parentId);



    /**
     * 新接口
     * */


    public void updateInputItem(InputItem item);

    public List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

    public long countInputItemInfoData(InputItemPageParam param);

    public List<InputItemVo> getInputItemInfo(InputItemPageParam param);

    public List<InputItemVo> getInputItemListByNames(@Param("itemNames") String[] items, @Param("orgCode") String orgCode);

    public List<PointInputItemVo> queryCustomInputItem( HashMap<String, Object> param );

    public List<InputItemVo> getInputItemListByitemNos(@Param("itemNos") String[] itemNos);

    public List<PointInputItemVo> queryCustomInputItemByPointId(@Param("classifyId") String classifyId );

    public PointInputItemVo getInputItemByEquipmentName(@Param("equipmentName") String equipmentName );

    void delPointInputItemById(@Param("ids") List<Long> ids);

    void delRoutePointItemByItemId(@Param("ids") List<Long> ids);
}
