package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.yeejoin.amos.boot.module.tdc.api.entity.CheckReport;
import com.yeejoin.amos.boot.module.tdc.api.enums.ReportStateEnum;
import com.yeejoin.amos.boot.module.tdc.api.feign.IdxFeignService;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckReportMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import springfox.documentation.spring.web.json.Json;

import java.util.HashMap;
import java.util.Map;

/**
 * @author DELL
 */
@Service
public class CheckReportImpl extends ServiceImpl<CheckReportMapper, CheckReport> implements CheckReportService {

    @Autowired
    IdxFeignService idxFeignService;

    @Override
    public IPage<CheckReport> selectAll(int current,int size,String amosOrgCode) {
        Page<CheckReport> page = new Page<>(current,size);

        LambdaQueryWrapper<CheckReport> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(CheckReport::getCreateDate);

        if(ValidationUtil.isEmpty(amosOrgCode)){

            return this.page(page,wrapper);
        }else{
            wrapper.likeRight(CheckReport::getAmosOrgCode, amosOrgCode);
            return this.page(page,wrapper);
        }
    }

    @Override
    public Map getInfo(int pageNumber,int pageSize){
        Map map = new HashMap<>();
        JSONObject object = idxFeignService.getInfo(pageNumber,pageSize).getResult();
        JSONArray jsonArray = object.getJSONArray("taskListModel");
        for(int i = 0 ; i<jsonArray.size(); i++){
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String status = jsonObject.getString("status");
            jsonObject.put("state",ReportStateEnum.map.get(status));

        map.put("current",object.getString("pageNumber"));
        map.put("records",jsonArray);
        map.put("total",object.getString("total"));
        return map;

    }
return null;
}
}