package com.yeejoin.amos.boot.module.tzs.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

/**
 * 
 * <pre>
 * 警情信息ES实体
 * </pre>
 *
 * @author litw
 * @date 2021-08-04
 */
@Data
@Accessors(chain = true)
@Document(indexName = "tzs", type = "tzsAlertCalled", shards = 3, replicas = 1)
public class ESAlertCalled {

    /** 主键 */
    @Id
    private Long sequenceNbr;
    /**
     * 警情状态
     */
    @Field(type = FieldType.Boolean, index = false)
    private Boolean alertStatus;
    /**
     * 警情状态
     */
    @Field(type = FieldType.Text)
    private String alertStatusStr;
    /**
     * 警情阶段
     */
    @Field(type = FieldType.Text, index = false)
    private String alertStage;
    /**
     * 联系人姓名
     */
    @Field(type = FieldType.Text)
    private String contactUser;
    /**
     * 联系人电话
     */
    @Field(type = FieldType.Text)
    private String contactPhone;
    /**
     * 接警时间
     */
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time, index = false)
    private Date callTime;
    /**
     * 接警时间
     */
    @Field(type = FieldType.Long)
    private Long callTimeLong;
    /**
     * 警情类型
     */
    @Field(type = FieldType.Text, index = false)
    private String alarmType;
    /**
     * 警情类型Code
     */
    @Field(type = FieldType.Text)
    private String alarmTypeCode;
    /**
     * 使用单位
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String useUnit;
    /**
     * 地址
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String address;

    /**
     * 电梯识别码
     */
    @Field(type = FieldType.Text, searchAnalyzer = "ik_max_word", analyzer = "ik_max_word")
    private String deviceId;


    /**
     * 求援人电话
     */
    @Field(type = FieldType.Text)
    private String emergencyCall;


    /**
     * 所属区域编码
     */
    @Field(type = FieldType.Text)
    private String regionCode;

}
