package com.yeejoin.amos.video.entity;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 模板表
 *
 * @author system_generator
 * @date 2021-09-01
 */
@Data
@Accessors(chain = true)
@Document(indexName = "video", type = "videoOriginal", shards = 3, replicas = 1)
public class EsVideoOriginal {
    /** 主键 */
    @Id
    private String sequenceNbr;

	/**
	 * 视频名称
	 */
	@Field(type = FieldType.Text)
	private String cn;

	/**
	 * 视频代码
	 */
	@Field(type = FieldType.Text)
	private String indexCode;
	/**
	 * 视频IP
	 */
	@Field(type = FieldType.Text)
	private String ip;
	/**
	 * 视频port
	 */
	@Field(type = FieldType.Text)
	private String port;
	/**
	 * 视频状态
	 */
	@Field(type = FieldType.Text)
	private String status;
	/**
	 * 原始数据
	 */
	@Field(type = FieldType.Text, index = false)
	private String originalData;
	/**
	 * 视频厂商类型
	 */
	@Field(type = FieldType.Keyword, index = false)
	private String type;
	@Field(type = FieldType.Text, index = false)
	private String recDate;
	@Field(type = FieldType.Text, index = false)
	private String recUserId;
	@Field(type = FieldType.Text, index = false)
	private String recUserName;

}
