package com.yeejoin.amos.boot.module.common.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.boot.module.common.biz.service.impl.RescueEquipmentServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.RescueEquipmentDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 救援装备
 *
 * @author system_generator
 * @date 2021-07-23
 */
@RestController
@Api(tags = "救援装备Api")
@RequestMapping(value = "/common/rescue-equipment")
public class RescueEquipmentController extends BaseController {

    @Autowired
    RescueEquipmentServiceImpl rescueEquipmentServiceImpl;

    /**
     * 新增救援装备
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增救援装备", notes = "新增救援装备")
    public ResponseModel<RescueEquipmentDto> save(@RequestBody RescueEquipmentDto model) {
        model = rescueEquipmentServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新救援装备", notes = "根据sequenceNbr更新救援装备")
    public ResponseModel<RescueEquipmentDto> updateBySequenceNbrRescueEquipment(@RequestBody RescueEquipmentDto model
            , @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除救援装备", notes = "根据sequenceNbr删除救援装备")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个救援装备", notes = "根据sequenceNbr查询单个救援装备")
    public ResponseModel<RescueEquipmentDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "救援装备分页查询", notes = "救援装备分页查询")
    public ResponseModel<Page<RescueEquipmentDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                @RequestParam(value = "size") int size,
                                                                Long companyId,
                                                                String vehicleTypeCode) {
        Page<RescueEquipmentDto> page = new Page<RescueEquipmentDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.queryForRescueEquipmentPage(page, false,
                companyId, vehicleTypeCode));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "救援装备列表全部数据查询", notes = "救援装备列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<RescueEquipmentDto>> selectForList() {
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.queryForRescueEquipmentList());
    }

    /**
     * 批量删除救援装备
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete_batch")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除合同信息", notes = "批量删除合同信息")
    public ResponseModel<Boolean> batchDeleteBySequenceNbrList(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.batchDelete(sequenceNbrList));
    }

    /**
     * 查询没有数据的岗位类型
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询没有数据的岗位类型", notes = "查询没有数据的岗位类型")
    @GetMapping(value = "/vehicle_list")
    public ResponseModel<HashMap<Object, Object>> getRescueEquipmentList(Long companyId) throws Exception {
        return ResponseHelper.buildResponse(rescueEquipmentServiceImpl.getRescueEquipmentList(companyId));
    }
}
