package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

@Component
public class InstallNoticeStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgInstallationNoticeServiceImpl jgInstallationNoticeService;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Map<String, Object>> notice = jgInstallationNoticeService.queryBySequenceNbr(sequenceNbr, reginParams.getCompany());

        Map<String, Object> installationInfo = notice.get("installationInfo");

        Map<String, Object> basic = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.AZGZ.getBusinessCode());
        basic.put("receiveOrgCreditCode", installationInfo.get("receiveOrgCreditCode"));
        basic.put("code", installationInfo.get("equListCode"));
        basic.put("equCategory", installationInfo.get("equCategoryCode"));
        basic.put("isTempEquip", true);
        installationInfo.put("equCategory", installationInfo.get("equCategoryCode"));
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", installationInfo);
        result.put("basic", basic);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_INSTALLATION_NOTIFICATION.getName();
    }
}
