package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 维修回访DTO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchRepairFeedbackDto", description="维修回访DTO")
public class DispatchRepairFeedbackDto extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "报修人")
    private String emergency;

    @ApiModelProperty(value = "报修人电话")
    private String emergencyCall;

    @ApiModelProperty(value = "报修反馈方式")
    private String fixFeedbackCode;

    @ApiModelProperty(value = "报修反馈结果")
    private String feedbackResult;

    @ApiModelProperty(value = "报修回访时间")
    private Date fixFeedbackTime;

    @ApiModelProperty(value = "报修回访人")
    private String fixFeedbackUname;

    @ApiModelProperty(value = "报修回访人Id")
    private String fixFeedbackUid;

    @ApiModelProperty(value = "报修备注")
    private String fixRemark;

    @ApiModelProperty(value = "响应人")
    private String responseUserName;

    @ApiModelProperty(value = "响应人电话")
    private String responseUserTel;

    @ApiModelProperty(value = "维修反馈方式Code")
    private String feedbackCode;

    @ApiModelProperty(value = "维修反馈方式")
    private String feedbackType;

    @ApiModelProperty(value = "维修结果")
    private String fixResult;

    @ApiModelProperty(value = "维修完成时间")
    private Date feedbackFinishTime;

    @ApiModelProperty(value = "维修反馈人id")
    private String feedbackUid;

    @ApiModelProperty(value = "维修反馈人")
    private String feedbackUname;

    @ApiModelProperty(value = "电梯故障原因分类")
    private String errorResult;

    @ApiModelProperty(value = "备注")
    private String Remark;

    @ApiModelProperty(value = "回访时间")
    private Date feedbackTime;


 public DispatchRepairFeedbackDto() {

    }
}
