package com.yeejoin.amos.boot.module.common.api.excel;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;

//如果没有特殊说明，下面的案例将默认使用这个监听器
public class ExcelListener<T> extends AnalysisEventListener<T> {

 List<T> list = new ArrayList<T>();
 
 public List<T> getList() {
	return list;
}

public void setList(List<T> list) {
	this.list = list;
}

/**
  * 如果使用了spring,请使用这个构造方法。每次创建Listener的时候需要把spring管理的类传进来
  */
 public ExcelListener() {}

 /**
  * 这个每一条数据解析都会来调用
  *
  * @param data
  * @param context
  */
 @Override
 public void invoke(T data, AnalysisContext context) {
     list.add(data);
 }

 /**
  * 所有数据解析完成了 都会来调用
  *
  * @param context
  */
 @Override
 public void doAfterAllAnalysed(AnalysisContext context) {
	 
 }
}
