package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2024-07-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_use_registration_manage")
public class JgUseRegistrationManage extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 使用登记证状态（已登记，已注销）
     */
	@TableField("certificate_status")
    private String certificateStatus;

    /**
     * 接收机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 办理日期
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 登记类别
     */
	@TableField("reg_type")
    private String regType;

    /**
     * 申请日期
     */
	@TableField("reg_date")
    private Date regDate;

    /**
     * 设备种类
     */
	@TableField("equ_list")
    private String equList;

    /**
     * 设备类别
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 设备品种
     */
	@TableField("equ_define")
    private String equDefine;


    /**
     * 设备种类编码
     */
    @TableField("equ_list_code")
    private String equListCode;

    /**
     * 设备类别编码
     */
    @TableField("equ_category_code")
    private String equCategoryCode;

    /**
     * 设备品种编码
     */
    @TableField("equ_define_code")
    private String equDefineCode;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 使用登记编号
     */
	@TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 接收机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 登记证书唯一标识
     */
	@TableField("certificate_no")
    private String certificateNo;

    /**
     * 设备使用地址
     */
    @TableField("equ_use_address")
    private String equUseAddress;

    /**
     * 使用单位地址
     */
    @TableField("use_unit_address")
    private String useUnitAddress;

    /**
     * 使用登记办理类型，unit单位, set台套
     */
    @TableField("manage_type")
    private String manageType;


    /**
     * 车牌号-车用气瓶登记
     */
    @TableField("car_number")
    private String carNumber;


    /**
     * 是否报废状态 1报废 0未报废
     */
    @TableField("is_scrap")
    private String isScrap;

    /**
     * 气瓶数量
     */
    @TableField("gas_num")
    private Integer gasNum;

    /**
     * 容积
     */
    @TableField("volume")
    private String volume;

    /**
     * 充装介质
     */
    @TableField("filling_medium")
    private String fillingMedium;


    /**
     * 登记版本号(每次业务+1, 作废业务-1)
     */
    @TableField("version")
    private Integer version = 1;

    /**
     * 变更原因
     */
    @TableField("change_reason")
    private String changeReason;
}
