package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.newEquip;

import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 设备/气瓶创建编辑-提醒处理器
 */
@Component
public class NewEquipReminderAdapter extends DefaultReminder {

    private final NewEquipParseService newEquipParseService;

    public NewEquipReminderAdapter(ApplicationContext applicationContext, NewEquipParseService newEquipParseService) {
        super(applicationContext);
        this.newEquipParseService = newEquipParseService;
    }

    @Override
    protected List<ReminderItemDto> realtimeParse(String bizId) {
        IdxBizJgRegisterInfo registerInfo = newEquipParseService.getIdxBizJgRegisterInfoService().getOneData(bizId);
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(bizId);
        reminderItemDto.setEquipNo(registerInfo.getEquCode());
        reminderItemDto.setEquipName(registerInfo.getProductName());
        reminderItemDto.setDetailData(newEquipParseService.getEquipDetailByRecord(bizId));
        return Collections.singletonList(reminderItemDto);
    }

    @Override
    public List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        IdxBizJgRegisterInfo registerInfo = CommonReminderService.geEquipInfoFromJson(formData, IdxBizJgRegisterInfo.class);
        IdxBizJgUseInfo bizJgUseInfo = CommonReminderService.geEquipInfoFromJson(formData, IdxBizJgUseInfo.class);
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(StringUtils.isEmpty(bizId) ? "1" : bizId);
        reminderItemDto.setEquipNo(bizJgUseInfo.getUseInnerCode());
        reminderItemDto.setEquipName(registerInfo.getProductName());
        reminderItemDto.setDetailData(newEquipParseService.getDetailInfoFromJson(formData));
        return Collections.singletonList(reminderItemDto);
    }

    @Override
    public MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        newEquipParseService.setEquCateInfoForInsert(formData, matchItemDto);
        matchItemDto.setIsRegister(newEquipParseService.getIsRegister(bizId));
        matchItemDto.setRegType(StringUtils.isNotEmpty(bizId) ? newEquipParseService.getRegTypeForEdit(bizId) : newEquipParseService.getRegTypeForInsert(formData));
        return matchItemDto;
    }

    @Override
    public MatchItemDto setMatchItem(String bizId) {
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        newEquipParseService.setEquCateInfoForEdit(bizId, matchItemDto);
        matchItemDto.setIsRegister(newEquipParseService.getIsRegister(bizId));
        matchItemDto.setRegType(newEquipParseService.getRegTypeForEdit(bizId));
        return matchItemDto;
    }

    @Override
    public String supportBizType() {
        return BusinessTypeEnum.JG_NEW_EQUIP.name();
    }
}
