package com.yeejoin.amos.boot.module.statistcs.biz.utils;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

public class MinioUtils {

    /**
     * 上传excel文件到minio服务器
     *
     * @param templateExcelFile 文件
     * @param bucketName 存储桶名称
     * @param bucketName 文件名称
     * @return minio文件路径
     */
    public static String uploadExcelFile(MultipartFile templateExcelFile, String bucketName, String uploadPath) {
        FeignClientResult<Map<String, String>> uploadResult = Systemctl.fileStorageClient.updateBucketFile(templateExcelFile, bucketName, uploadPath);

        String urlString = "";
        if (uploadResult != null && uploadResult.getResult() != null) {
            for (String s : uploadResult.getResult().keySet()) {
                urlString = s;
            }
        }
        return urlString;
    }
}
