package com.yeejoin.amos.boot.module.jczs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 
 * <pre>
 * 警情状态枚举
 * </pre>
 *
 * @author litw
 * @date 2021-08-03
 */
@Getter
@AllArgsConstructor
public enum AlertStatusEnum {

	UNCLOSED("unclosed", "未结案"),
	CLOSED("closed", "已结案");

    private String code;
    private String name;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
	public static AlertStatusEnum getEnum(String code)
	{
		for (AlertStatusEnum status : AlertStatusEnum.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}
}

