package com.yeejoin.amos.api.openapi.face.model;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * <p>
 * 电梯运行状态表
 * </p>
 *
 * @author 子杨
 * @since 2021-09-28
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ElevatorStatusModel extends BaseModel {

        /**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = -4386647424329118778L;

	    /**
         * 电梯注册码
         */
    private String registerCode;
	    /**
	     * 原始状态编码
	     */
    private String statusId;
        /**
         * 是否在线。1：是，0：否
         */
    private Integer isOnline;
        /**
         * 运行数据上传时间字符串(格式为：yyyymmddhhmmss)
         */
    private String uploadTime;
	    /**
	     * 运行数据上传时间
	     */
    private Date uploadDate;
        /**
         * 总接触器吸合或是断开。0：吸合，1：断开
         */
    private Integer mainContactor;
    private String mainContactorName;
        /**
         * 运行接触器吸合或是断开。0：吸合，1：断开
         */
    private Integer runContactor;
    private String runContactorName;
        /**
         * 安全回路是否断开，0：正常，1：断开
         */
    private Integer circuit;
    private String circuitName;
        /**
         * 当前电梯运行模式。1：停止服务 2：正常运行 3：检修 4：消防返回 5：消防员运行 6：应急电源运行 7：地震模式 8: 未知
         */
    private Integer serviceModel;
    private String serviceModelName;
        /**
         * 轿厢运行状态。1：停止，2：运行
         */
    private Integer liftStatus;
    private String liftStatusName;
        /**
         * 轿厢运行方向。1：无方向 2：上行 3：下行
         */
    private Integer liftDirection;
    private String liftDirectionName;
        /**
         * 轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区
         */
    private Integer isZone;
        /**
         * 运行速度，单位：cm/s
         */
    private Integer elevatorSpeed;
        /**
         * 当前物理楼层
         */
    private Integer currFloor;
        /**
         * 关门到位 1：关门到位，0：无关门到位信号
         */
    private Integer doorStatus;
    private String doorStatusName;
        /**
         * 上极限是否动作 0:否，1：是
         */
    private Integer upLimit;
        /**
         * 下极限是否动作 0:否，1：是
         */
    private Integer downLimit;
        /**
         * 轿厢报警按钮是否动作 0:否，1：是
         */
    private Integer alarm;
        /**
         * 轿厢内是否有人 0：无，1：有
         */
    private Integer personFlag;
    private String personFlagName;
        /**
         * 累计运行小时数，保留到小数点后两位
         */
    private Double hours;
        /**
         * 累计运行次数
         */
    private Integer runCount;
        /**
         * 操作人名称
         */
    private String recUserName;
        /**
         * 是否删除
         */
    private Boolean isDelete;

}
