package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Administrator
 */
@Getter
public enum DPMapStatisticsItemEnum {
    /**
     * 大屏统计项
     */

    TOTAL("特种设备总量 (台)", "total", ""),
    OVER15YEARS_ELEVATORS("超过15年电梯数量", "over15yearsCount", ""),
    USE_REGISTRATION_COUNT("使用登记办理量", "useRegistrationCount", ""),
    CONSTRUCTION_NOTICE_COUNT("施工告知办理量", "constructionNoticeCount", ""),
    CHANGE_COUNT("变更办理量", "changeCount", ""),
    GAS("气瓶 (台)", "gas", ""),
    ELEVATORS("电梯 (台)", "elevators", "3000"),
    PRESSURE_VESSELS("压力容器 (台)", "pressureVessels", "2000"),
    ON_SITE_MOTOR_VEHICLES("场（厂）内机动车 (台)", "onSiteMotorVehicles", "5000"),
    BOILERS("锅炉 (台)", "boilers", "1000"),
    LIFTING_MACHINERY("起重机械 (台)", "liftingMachinery", "4000"),
    LARGE_AMUSEMENT_FACILITIES("大型游乐设施 (台)", "largeAmusementFacilities", "6000"),
    PRESSURE_PIPELINES("压力管道 (千米)", "pressurePipelines", "8000"),
    PASSENGER_ROPEWAYS("客运索道 (台)", "passengerRopeways", "9000"),
    MANUFACTURING_UNITS("制造单位 (家)", "manufacturingUnits", ""),
    CONSTRUCTION_UNITS("安改维单位 (家)", "constructionUnits", ""),
    COMPANY_TOTAL("企业总量 (家)", "companyTotal", ""),
    INSPECTION_AGENCY_COUNT("检验检测机构总数 (家)", "inspectionAgencyCount", ""),
    USERS_UNITS("使用单位 (家)", "usersUnits", ""),
    PERMIT_UNITS("许可单位 (家)", "permitUnits", ""),
    GAS_UNITS("充装单位 (家)", "gasUnits", ""),
    DESIGN_UNITS("设计单位 (家)", "designUnits", ""),
    PERSON_TOTAL("企业人员总数 (人)", "personTotal", ""),
    INSPECTION_PERSON_TOTAL("检验检测人员总数 (人)", "jyjcryzl", ""),
    OPERATORS("作业人员 (人)", "operators", ""),
    DEVICE_COUNT("已纳管设备数", "deviceCount", ""),
    PERSON_ISSUES_COUNT("个人问题数", "个人", ""),
    COMPANY_ISSUES_COUNT("企业问题数", "企业", ""),
    EQU_ISSUES_COUNT("设备数", "设备", ""),
    CERTIFICATE_COUNT("登记证总量", "certificateCount", "");
    private String label;
    private String code;
    private String category;

    DPMapStatisticsItemEnum(String label, String code, String category) {
        this.label = label;
        this.code = code;
        this.category = category;
    }

    public static DPMapStatisticsItemEnum getInstanceByCategory(String category) {
        Optional<DPMapStatisticsItemEnum> op = Arrays.stream(DPMapStatisticsItemEnum.values()).filter(e -> e.category.equals(category)).findAny();
        return op.orElseThrow(() -> new RuntimeException("未知的类型"));
    }


}
