package com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 户用光伏监盘采集器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@Accessors(chain = true)
@TableName("hygf_jp_collector")
public class JpCollector implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 是否删除
     */
    @TableField(value = "is_delete")
    public Boolean isDelete = false;
    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;
    @TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
    protected Date recDate;
    @TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String recUserId;
    @TableField(value = "rec_user_name", fill = FieldFill.INSERT_UPDATE)
    protected String recUserName;
    /**
     * sn编码
     */
    @TableField("sn_code")
    private String snCode;

    /**
     * 状态
     */
    @TableField("state")
    private String state;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * sim卡号
     */
    @TableField("sim_code")
    private String simCode;

    /**
     * 数据来源
     */
    @TableField("data_source")
    private String dataSource;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 采集器版本
     */
    @TableField("version")
    private String version;

    /**
     * 出场日期
     */
    @TableField("discharge_date")
    private Date dischargeDate;

    /**
     * 生产日期
     */
    @TableField("product_date")
    private Date productDate;

    /**
     * 数据上传间隔
     */
    @TableField("data_period")
    private Double dataPeriod;

    /**
     * 本次上电工作时间
     */
    @TableField("this_work_time")
    private Date thisWorkTime;

    /**
     * 累计工作时间
     */
    @TableField("total_work_time")
    private Date totalWorkTime;

    /**
     * 第三方电站id
     */
    @TableField("third_station_id")
    private String thirdStationId;

    /**
     * 第三方厂商标识
     */
    @TableField("third_code")
    private String thirdCode;
    /**
     * 场站名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 场站地址
     */
    @TableField("addr")
    private String addr;
    /**
     * 场站地址
     */
    @TableField("name")
    private String name;
    /**
     * 信号强度
     */
    @TableField("signal_strength")
    private String signalStrength;
}
