package com.yeejoin.amos.file.convert;

import java.io.OutputStream;

import com.aspose.pdf.*;
import com.aspose.pdf.devices.EmfDevice;
import com.aspose.pdf.devices.Resolution;


public class EMFConvert {
	/**
	 * pdf转为emf文件，只能转换一页
	 */
	public static void pdf2emf(String inputPath, String outPath){
	    // instantiate EmfDevice object
	    EmfDevice device = new EmfDevice(new Resolution(96));
	    // load existing PDF file
	    Document doc = new Document(inputPath);
	    // save first page of PDF file as Emf image
	    device.process(doc.getPages().get_Item(1), outPath);
	}
	
	/**
	 * pdf转为emf文件，只能转换一页
	 */
	public static void pdf2emf(String inputPath, OutputStream out){
	    // instantiate EmfDevice object
	    EmfDevice device = new EmfDevice(new Resolution(96));
	    // load existing PDF file
	    Document doc = new Document(inputPath);
	    // save first page of PDF file as Emf image
	    device.process(doc.getPages().get_Item(1), out);
	}
}
