package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 验收状态枚举
 */
@Getter
@AllArgsConstructor
@SuppressWarnings("ALL")
public enum BasicGridAcceptancEnum {

    并网管理端工程审核("hygf_bw2", "hygf_bw2"),
    经销商工程提交验收("hygf_ys1", "hygf_ys1"),
    管理端投融审核("hygf_ys2", "hygf_ys2"),
    管理端法务审核("hygf_ys3", "hygf_ys3"),
    管理端工程审核("hygf_ys4", "hygf_ys4"),
    管理端工程是否线下("hygf_ys5", "hygf_ys5"),
    管理端工程线下验("hygf_ys6", "hygf_ys6");

    /**
     * 名称，描述
     */
    private final String rule;
    /**
     * 编码
     */
    private final String code;



    public static BasicGridAcceptancEnum getNodeByCode(String code) {
        BasicGridAcceptancEnum acceptanceStatusEnum = null;
        for (BasicGridAcceptancEnum type : BasicGridAcceptancEnum.values()) {
            if (type.getCode() .equals(code) ) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum;
    }

}
