package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jxiop.api.entity.YwpgMoudleInfo;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.YwpgMoudleInfoMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.amosprojectmapper.UserEmpowerMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.StdUserEmpower;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class YwpgModuleInfoServiceImpl {
    @Autowired
    YwpgMoudleInfoMapper ywpgMoudleInfoMapper;

    @Autowired
    private UserEmpowerMapper userEmpowerMapper;

    public List<Map<String, Object>> getIdxAuthInfo(ReginParams reginParams) {
        List<Map<String, Object>> result = new ArrayList<>();
        String userId = reginParams.getUserModel().getUserId();
        StdUserEmpower stdUserEmpower = userEmpowerMapper
                .selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
        String orgCode = "86";
        if(!ObjectUtils.isEmpty(stdUserEmpower)){
            orgCode = stdUserEmpower.getAmosOrgCode().get(0);
        }
        List<YwpgMoudleInfo> ywpgMoudleInfoList = ywpgMoudleInfoMapper.selectList(new QueryWrapper<YwpgMoudleInfo>().isNotNull("module_name").isNotNull("module_table_id"));
        String finalOrgCode = orgCode;
        ywpgMoudleInfoList.stream().forEach(ywpgMoudleInfo -> {
            Map<String,Object> item = new HashMap<>();
            Map<String,Object> filtersItem = new HashMap<>();
            item.put("name",ywpgMoudleInfo.getModuleName());
            item.put("tableId",ywpgMoudleInfo.getModuleTableId());
            filtersItem.put("searchColumn","CODE");
            filtersItem.put("condition","startsWith");
            filtersItem.put("value", finalOrgCode);
            List<Map<String,Object>> filters = new ArrayList<>();
            filters.add(filtersItem);
            item.put("filters",filters);
            result.add(item);
        });
        return result;
    }

    public String  getJxiopOrgCode (ReginParams reginParams) {
        String orgCode = "86";
        String userId = reginParams.getUserModel().getUserId();
        StdUserEmpower stdUserEmpower = userEmpowerMapper
                .selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
        if(!ObjectUtils.isEmpty(stdUserEmpower)){
            orgCode = stdUserEmpower.getAmosOrgCode().get(0);
        }
        return orgCode;
    }
}
