package com.yeejoin.amos.boot.module.statistics.api.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.yeejoin.amos.boot.module.common.api.converter.CommonCustomConverter;
import com.yeejoin.amos.boot.module.common.api.converter.CompanyFieldCustomConverter;
import lombok.*;

import java.util.Date;

/**
 * 企业
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
@HeadRowHeight(35)// 标题行高度
@ContentRowHeight(15)// 内容行高度
@ColumnWidth(30)// 默认列宽
public class CompanyInfoVo {

    // --------------------------  基本信息 -------------------------------

    @ExcelProperty("企业名称")
    private String useUnit;

    @ExcelProperty("企业统一信用代码")
    private String useCode;

    @ExcelProperty("单位类型")
    private String unitType;

    @ExcelProperty("管辖机构名称")
    private String superviseOrgName;

    @ExcelProperty("监管系统唯一编码")
    private String superviseCode;

    @ExcelProperty("联系人")
    private String contactUser;

    @ExcelProperty("联系人电话")
    private String contactPhone;

    @ExcelProperty("企业详情地址")
    private String address;

    @ExcelProperty("监管标签")
    private String regulatoryLabels;

    @ExcelProperty(value = "行业主管部门", converter = CompanyFieldCustomConverter.HYZGBMTypeConverter.class)
    private String industrySupervisor;

    @ExcelProperty("经营状态")
    private String operatingStatus;

    @ExcelProperty(value = "涉及设备类型", converter = CompanyFieldCustomConverter.InvolvedEquipTypeConverter.class)
    @ColumnWidth(50)
    private String equipCategory;


    @ExcelProperty("办公区域")
    private String officeRegion;

    // ------------------------------------- 资质 ------------------------------------
    @ExcelProperty(value = {"资质信息", "证书编号"})
    private String certNo;

    @ExcelProperty(value = {"资质信息", "证书类型名称"})
    private String certType;

    @ExcelProperty(value = {"资质信息", "发证机关"}, converter = CompanyFieldCustomConverter.ApprovedOrganCodeConverter.class)
    private String approvedOrganCode;

    @ExcelProperty(value = {"资质信息", "许可到期日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date expiryDate;

    @ExcelProperty(value = {"资质信息", "许可项目/检验类型/设备品种（核准项目名称）"}, converter = CompanyFieldCustomConverter.ItemCodeConverter.class)
    @ColumnWidth(80)
    private String itemCode;

    @ExcelProperty(value = {"资质信息", "机构类别枚举"}, converter = CompanyFieldCustomConverter.AgencyTypeConverter.class)
    private String agencyType;

    @ExcelProperty(value = {"资质信息", "资质类型编码（检验检测、其他）"}, converter = CompanyFieldCustomConverter.LicenceTypeConverter.class)
    private String licenceType;

    @ExcelProperty(value = {"资质信息", "发证日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date issueDate;
}

 